// 555astaDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "555astaDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// C555astaDlg dialog


C555astaDlg::C555astaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(C555astaDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(C555astaDlg)
	m_c = _T("");
	m_duty = _T("");
	m_f = _T("");
	m_r1 = _T("");
	m_r2 = _T("");
	m_select = -1;
	m_t = _T("");
	m_th = _T("");
	m_tl = _T("");
	//}}AFX_DATA_INIT
}


void C555astaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(C555astaDlg)
	DDX_Text(pDX, IDC_555ASTA_C, m_c);
	DDX_Text(pDX, IDC_555ASTA_DUTY, m_duty);
	DDX_Text(pDX, IDC_555ASTA_F, m_f);
	DDX_Text(pDX, IDC_555ASTA_R1, m_r1);
	DDX_Text(pDX, IDC_555ASTA_R2, m_r2);
	DDX_Radio(pDX, IDC_555ASTA_RADIO1, m_select);
	DDX_Text(pDX, IDC_555ASTA_T, m_t);
	DDX_Text(pDX, IDC_555ASTA_TH, m_th);
	DDX_Text(pDX, IDC_555ASTA_TL, m_tl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(C555astaDlg, CDialog)
	//{{AFX_MSG_MAP(C555astaDlg)
	ON_BN_CLICKED(ID_555ASTA_HELP, On555astaHelp)
	ON_BN_CLICKED(ID_555ASTA_OK, On555astaOk)
	ON_BN_CLICKED(IDC_555ASTA_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_555ASTA_RADIO2, Calcul)
	ON_BN_CLICKED(IDC_555ASTA_RADIO3, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL C555astaDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// C555astaDlg message handlers

void C555astaDlg::On555astaHelp() 
{
	// TODO: Add your control notification handler code here
	WinHelp(HPC_555ASTA,HELP_CONTEXT);
}

void C555astaDlg::On555astaOk() 
{
	// TODO: Add your control notification handler code here
	CDialog::OnOK();
}

void C555astaDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double r1,r2,c,t,th,tl,f,duty;

	// Read current values
	UpdateData(TRUE);
	r1=fabs(ToDouble(m_r1));
	r2=fabs(ToDouble(m_r2));
	c=fabs(ToDouble(m_c));
	t=fabs(ToDouble(m_t));
	th=fabs(ToDouble(m_th));
	tl=fabs(ToDouble(m_tl));
	f=fabs(ToDouble(m_f));
	duty=fabs(ToDouble(m_duty))/100.0;
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// r1,r2,c
		GetDlgItem(IDC_555ASTA_R1)->EnableWindow(TRUE);
		GetDlgItem(IDC_555ASTA_R2)->EnableWindow(TRUE);
		GetDlgItem(IDC_555ASTA_C)->EnableWindow(TRUE);
		GetDlgItem(IDC_555ASTA_T)->EnableWindow(FALSE);
		GetDlgItem(IDC_555ASTA_TH)->EnableWindow(FALSE);
		GetDlgItem(IDC_555ASTA_TL)->EnableWindow(FALSE);
		GetDlgItem(IDC_555ASTA_F)->EnableWindow(FALSE);
		GetDlgItem(IDC_555ASTA_DUTY)->EnableWindow(FALSE);
		break;
	case 1:	// C,th,tl
		GetDlgItem(IDC_555ASTA_R1)->EnableWindow(FALSE);
		GetDlgItem(IDC_555ASTA_R2)->EnableWindow(FALSE);
		GetDlgItem(IDC_555ASTA_C)->EnableWindow(TRUE);
		GetDlgItem(IDC_555ASTA_T)->EnableWindow(FALSE);
		GetDlgItem(IDC_555ASTA_TH)->EnableWindow(TRUE);
		GetDlgItem(IDC_555ASTA_TL)->EnableWindow(TRUE);
		GetDlgItem(IDC_555ASTA_F)->EnableWindow(FALSE);
		GetDlgItem(IDC_555ASTA_DUTY)->EnableWindow(FALSE);
		break;
	case 2:	// C,f,duty%
		GetDlgItem(IDC_555ASTA_R1)->EnableWindow(FALSE);
		GetDlgItem(IDC_555ASTA_R2)->EnableWindow(FALSE);
		GetDlgItem(IDC_555ASTA_C)->EnableWindow(TRUE);
		GetDlgItem(IDC_555ASTA_T)->EnableWindow(FALSE);
		GetDlgItem(IDC_555ASTA_TH)->EnableWindow(FALSE);
		GetDlgItem(IDC_555ASTA_TL)->EnableWindow(FALSE);
		GetDlgItem(IDC_555ASTA_F)->EnableWindow(TRUE);
		GetDlgItem(IDC_555ASTA_DUTY)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// r1,r2,c
		if (r1<100)
			r1=FLOATERR;
		th=0.693*(r1+r2)*c;
		tl=0.693*r2*c;
		t=th+tl;
		if (t>1e-12)
			f=1/t;
		else
			f=FLOATERR;
		if (r1>100)
			duty=1.0-r2/(r1+2*r2);
		else
			duty=FLOATERR;
		break;
	case 1:	// c,th,tl
		if ((c>1e-12) && (th>tl))
		{
			r2=tl/(0.693*c);
			r1=th/(0.693*c)-r2;
			if (r1<100)
				r1=FLOATERR;
			t=th+tl;
			if (t>1e-12)
				f=1/t;
			else
				f=FLOATERR;
			if (r1>1e-12)
				duty=1.0-r2/(r1+2*r2);
		}
		else
			r1=r2=t=f=duty=FLOATERR;
		break;
	case 2: // c,f,duty
		if ((c>1e-12) && (f>1e-12) && (duty>0.5))
		{
			t=1/f;
			r2=(1.0-duty)/(0.693*f*c);
			r1=1/(0.693*f*c)-2*r2;
			if (r1<100)
				r1=FLOATERR;
			th=0.693*(r1+r2)*c;
			tl=0.693*r2*c;
		}
		else
			t=r1=r2=th=tl=FLOATERR;
		break;
	}

	// Put back calculated values
	m_r1=ToCString(r1);
	m_r2=ToCString(r2);
	m_c=ToCString(c);
	m_t=ToCString(t);
	m_th=ToCString(th);
	m_tl=ToCString(tl);
	m_f=ToCString(f);
	m_duty=ToCString(duty*100.0);
	UpdateData(FALSE);
}

BOOL C555astaDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_r1="2.2k";
	m_r2="2.2k";
	m_c="10n";
	m_t="1";
	m_th="1";
	m_tl="1";
	m_duty="1";
	m_f="1";
	m_select=0;
	UpdateData(FALSE);
	Calcul();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


