// AopintDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "AopintDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAopintDlg dialog


CAopintDlg::CAopintDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAopintDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAopintDlg)
	m_c = _T("");
	m_deltat = _T("");
	m_r = _T("");
	m_select = -1;
	//}}AFX_DATA_INIT
}


void CAopintDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAopintDlg)
	DDX_Text(pDX, IDC_AOPINT_C, m_c);
	DDX_Text(pDX, IDC_AOPINT_DELTAT, m_deltat);
	DDX_Text(pDX, IDC_AOPINT_R, m_r);
	DDX_Radio(pDX, IDC_AOPINT_RADIO1, m_select);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAopintDlg, CDialog)
	//{{AFX_MSG_MAP(CAopintDlg)
	ON_BN_CLICKED(ID_AOPINT_HELP, OnAopintHelp)
	ON_BN_CLICKED(ID_AOPINT_OK, OnAopintOk)
	ON_BN_CLICKED(IDC_AOPINT_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_AOPINT_RADIO2, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CAopintDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CAopintDlg message handlers

void CAopintDlg::OnAopintHelp() 
{
	// TODO: Add your control notification handler code here
	WinHelp(HPC_AOPINT,HELP_CONTEXT);

}

void CAopintDlg::OnAopintOk() 
{
	// TODO: Add your control notification handler code here
	CDialog::OnOK();
}

void CAopintDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double r,c,deltat;

	// Read current values
	UpdateData(TRUE);
	r=fabs(ToDouble(m_r));
	c=fabs(ToDouble(m_c));
	deltat=fabs(ToDouble(m_deltat));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// r,c
		GetDlgItem(IDC_AOPINT_R)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPINT_C)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPINT_DELTAT)->EnableWindow(FALSE);
		break;
	case 1:	// r,deltat
		GetDlgItem(IDC_AOPINT_R)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPINT_C)->EnableWindow(FALSE);
		GetDlgItem(IDC_AOPINT_DELTAT)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// r,c
		deltat=0.7*r*c;
		break;
	case 1:	// r,deltat
		if (deltat>1e-12)
		{
			c=deltat/(0.7*r);
		}
		else
			c=FLOATERR;
		break;
	}

	// Put back calculated values
	m_r=ToCString(r);
	m_c=ToCString(c);
	m_deltat=ToCString(deltat);
	UpdateData(FALSE);

}

BOOL CAopintDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_r="2.2k";
	m_c="10n";
	m_deltat="1";
	m_select=0;
	UpdateData(FALSE);
	Calcul();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
