// AopinvDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "AopinvDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAopinvDlg dialog


CAopinvDlg::CAopinvDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAopinvDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAopinvDlg)
	m_g = _T("");
	m_r1 = _T("");
	m_r2 = _T("");
	m_select = -1;
	//}}AFX_DATA_INIT
}


void CAopinvDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAopinvDlg)
	DDX_Text(pDX, IDC_AOPINV_G, m_g);
	DDX_Text(pDX, IDC_AOPINV_R1, m_r1);
	DDX_Text(pDX, IDC_AOPINV_R2, m_r2);
	DDX_Radio(pDX, IDC_AOPINV_RADIO1, m_select);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAopinvDlg, CDialog)
	//{{AFX_MSG_MAP(CAopinvDlg)
	ON_BN_CLICKED(ID_AOPINV_OK, OnAopinvOk)
	ON_BN_CLICKED(ID_AOPINV_HELP, OnAopinvHelp)
	ON_BN_CLICKED(IDC_AOPINV_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_AOPINV_RADIO2, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CAopinvDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CAopinvDlg message handlers

void CAopinvDlg::OnAopinvOk() 
{
	// TODO: Add your control notification handler code here
	CDialog::OnOK();	
}

void CAopinvDlg::OnAopinvHelp() 
{
	// TODO: Add your control notification handler code here
	WinHelp(HPC_AOPINV,HELP_CONTEXT);	
}

void CAopinvDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double r1,r2,g;

	// Read current values
	UpdateData(TRUE);
	r1=fabs(ToDouble(m_r1));
	r2=fabs(ToDouble(m_r2));
	g=fabs(ToDouble(m_g));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// r1,r2
		GetDlgItem(IDC_AOPINV_R1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPINV_R2)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPINV_G)->EnableWindow(FALSE);
		break;
	case 1:	// r1,g
		GetDlgItem(IDC_AOPINV_R1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPINV_R2)->EnableWindow(FALSE);
		GetDlgItem(IDC_AOPINV_G)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// r1,r2
		if((r1>1e-12))
			g=r2/r1;
		else
			g=FLOATERR;
		break;
	case 1:	// r1,g
		r2=r1*g;
		break;
	}

	// Put back calculated values
	m_r1=ToCString(r1);
	m_r2=ToCString(r2);
	m_g=ToCString(g);
	UpdateData(FALSE);

}

BOOL CAopinvDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_r1="2.2k";
	m_r2="4.7k";
	m_g="1";
	m_select=0;
	UpdateData(FALSE);
	Calcul();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
