// DecibelDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "DecibelDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDecibelDlg dialog


CDecibelDlg::CDecibelDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDecibelDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDecibelDlg)
	m_select = -1;
	m_gain = _T("");
	m_pi = _T("");
	m_po = _T("");
	m_ui = _T("");
	m_uo = _T("");
	//}}AFX_DATA_INIT
}


void CDecibelDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDecibelDlg)
	DDX_Radio(pDX, IDC_DECIBEL_RADIO1, m_select);
	DDX_Text(pDX, IDC_DECIBEL_GAIN, m_gain);
	DDX_Text(pDX, IDC_DECIBEL_PI, m_pi);
	DDX_Text(pDX, IDC_DECIBEL_PO, m_po);
	DDX_Text(pDX, IDC_DECIBEL_UI, m_ui);
	DDX_Text(pDX, IDC_DECIBEL_UO, m_uo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDecibelDlg, CDialog)
	//{{AFX_MSG_MAP(CDecibelDlg)
	ON_BN_CLICKED(ID_DECIBEL_HELP, OnDecibelHelp)
	ON_BN_CLICKED(ID_DECIBEL_OK, OnDecibelOk)
	ON_BN_CLICKED(IDC_DECIBEL_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_DECIBEL_RADIO2, Calcul)
	ON_BN_CLICKED(IDC_DECIBEL_RADIO3, Calcul)
	ON_BN_CLICKED(IDC_DECIBEL_RADIO4, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CDecibelDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CDecibelDlg message handlers

void CDecibelDlg::OnDecibelHelp() 
{
	WinHelp(HPC_DECIBEL,HELP_CONTEXT);	
}

void CDecibelDlg::OnDecibelOk() 
{
	CDialog::OnOK();	
}

void CDecibelDlg::Calcul() 
{
	double ui,pi,gain,uo,po;

	// Read current values
	UpdateData(TRUE);
	ui=fabs(ToDouble(m_ui));
	pi=fabs(ToDouble(m_pi));
	gain=ToDouble(m_gain);
	uo=fabs(ToDouble(m_uo));
	po=fabs(ToDouble(m_po));

	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// input&gain
		GetDlgItem(IDC_DECIBEL_UI)->EnableWindow(TRUE);
		GetDlgItem(IDC_DECIBEL_PI)->EnableWindow(TRUE);
		GetDlgItem(IDC_DECIBEL_GAIN)->EnableWindow(TRUE);
		GetDlgItem(IDC_DECIBEL_UO)->EnableWindow(FALSE);
		GetDlgItem(IDC_DECIBEL_PO)->EnableWindow(FALSE);
		break;
	case 1:	// gain&output
		GetDlgItem(IDC_DECIBEL_UI)->EnableWindow(FALSE);
		GetDlgItem(IDC_DECIBEL_PI)->EnableWindow(FALSE);
		GetDlgItem(IDC_DECIBEL_GAIN)->EnableWindow(TRUE);
		GetDlgItem(IDC_DECIBEL_UO)->EnableWindow(TRUE);
		GetDlgItem(IDC_DECIBEL_PO)->EnableWindow(TRUE);
		break;
	case 2:	// input/output level
		GetDlgItem(IDC_DECIBEL_UI)->EnableWindow(TRUE);
		GetDlgItem(IDC_DECIBEL_PI)->EnableWindow(TRUE);
		GetDlgItem(IDC_DECIBEL_GAIN)->EnableWindow(FALSE);
		GetDlgItem(IDC_DECIBEL_UO)->EnableWindow(TRUE);
		GetDlgItem(IDC_DECIBEL_PO)->EnableWindow(FALSE);
		break;
	case 3:	// input/output power
		GetDlgItem(IDC_DECIBEL_UI)->EnableWindow(TRUE);
		GetDlgItem(IDC_DECIBEL_PI)->EnableWindow(TRUE);
		GetDlgItem(IDC_DECIBEL_GAIN)->EnableWindow(FALSE);
		GetDlgItem(IDC_DECIBEL_UO)->EnableWindow(FALSE);
		GetDlgItem(IDC_DECIBEL_PO)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// input&gain
		uo=ui*pow(10,gain/20.0);
		po=pi*pow(10,gain/10.0);
		break;
	case 1:	// gain&output
		ui=uo/pow(10,gain/20.0);
		pi=po/pow(10,gain/10.0);
		break;
	case 2:	// int/out level
		if ((ui>1e-12) && (uo>1e-12))
		{
			gain=20.0*log10(uo/ui);
			po=pi*pow(10,gain/10.0);
		}
		else
			gain=po=FLOATERR;
		break;
	case 3:	// in/out power
		if ((pi>1e-12) && (po>1e-12))
		{
			gain=10.0*log10(po/pi);
			uo=ui*pow(10,gain/20.0);
		}
		else
			gain=uo=FLOATERR;
		break;
	}

	// Put back calculated values
	m_ui=ToCString(ui);
	m_pi=ToCString(pi);
	m_gain=ToCString(gain);
	m_uo=ToCString(uo);
	m_po=ToCString(po);
	UpdateData(FALSE);
}

BOOL CDecibelDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_ui="1";
	m_pi="1m";
	m_gain="20";
	m_uo="0";
	m_po="0";
	m_select=0;
	UpdateData(FALSE);
	Calcul();
		
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
