// HeatDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "HeatDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHeatDlg dialog


CHeatDlg::CHeatDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CHeatDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CHeatDlg)
	m_p = _T("");
	m_select = -1;
	m_rthha = _T("");
	m_rthjp = _T("");
	m_rthph = _T("");
	m_ta = _T("");
	m_tjmax = _T("");
	//}}AFX_DATA_INIT
}


void CHeatDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CHeatDlg)
	DDX_Text(pDX, IDC_HEAT_P, m_p);
	DDX_Radio(pDX, IDC_HEAT_RADIO1, m_select);
	DDX_Text(pDX, IDC_HEAT_RTHHA, m_rthha);
	DDX_Text(pDX, IDC_HEAT_RTHJP, m_rthjp);
	DDX_Text(pDX, IDC_HEAT_RTHPH, m_rthph);
	DDX_Text(pDX, IDC_HEAT_TA, m_ta);
	DDX_Text(pDX, IDC_HEAT_TJMAX, m_tjmax);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHeatDlg, CDialog)
	//{{AFX_MSG_MAP(CHeatDlg)
	ON_BN_CLICKED(ID_HEAT_HELP, OnHeatHelp)
	ON_BN_CLICKED(ID_HEAT_OK, OnHeatOk)
	ON_BN_CLICKED(IDC_HEAT_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_HEAT_RADIO2, Calcul)
	ON_BN_CLICKED(IDC_HEAT_RADIO3, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CHeatDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CHeatDlg message handlers

void CHeatDlg::OnHeatHelp() 
{
	WinHelp(HPC_HEAT,HELP_CONTEXT);	
}

void CHeatDlg::OnHeatOk() 
{
	CDialog::OnOK();	
}

void CHeatDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double rthha,rthjp,rthph,ta,tjmax,p;

	// Read current values
	UpdateData(TRUE);
	rthha=fabs(ToDouble(m_rthha));
	rthjp=fabs(ToDouble(m_rthjp));
	rthph=fabs(ToDouble(m_rthph));
	ta=ToDouble(m_ta);
	tjmax=fabs(ToDouble(m_tjmax));
	p=fabs(ToDouble(m_p));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// all but rthha
		GetDlgItem(IDC_HEAT_RTHHA)->EnableWindow(FALSE);
		GetDlgItem(IDC_HEAT_RTHJP)->EnableWindow(TRUE);
		GetDlgItem(IDC_HEAT_RTHPH)->EnableWindow(TRUE);
		GetDlgItem(IDC_HEAT_TA)->EnableWindow(TRUE);
		GetDlgItem(IDC_HEAT_TJMAX)->EnableWindow(TRUE);
		GetDlgItem(IDC_HEAT_P)->EnableWindow(TRUE);
		break;
	case 1:	// all but Ta
		GetDlgItem(IDC_HEAT_RTHHA)->EnableWindow(TRUE);
		GetDlgItem(IDC_HEAT_RTHJP)->EnableWindow(TRUE);
		GetDlgItem(IDC_HEAT_RTHPH)->EnableWindow(TRUE);
		GetDlgItem(IDC_HEAT_TA)->EnableWindow(FALSE);
		GetDlgItem(IDC_HEAT_TJMAX)->EnableWindow(TRUE);
		GetDlgItem(IDC_HEAT_P)->EnableWindow(TRUE);
		break;
	case 2:	// all but Tjmax
		GetDlgItem(IDC_HEAT_RTHHA)->EnableWindow(TRUE);
		GetDlgItem(IDC_HEAT_RTHJP)->EnableWindow(TRUE);
		GetDlgItem(IDC_HEAT_RTHPH)->EnableWindow(TRUE);
		GetDlgItem(IDC_HEAT_TA)->EnableWindow(TRUE);
		GetDlgItem(IDC_HEAT_TJMAX)->EnableWindow(FALSE);
		GetDlgItem(IDC_HEAT_P)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// all but RthHA
		if ((tjmax>ta) && (p>1e-12))
		{
			rthha=(tjmax-ta)/p-rthph-rthjp;
			if (rthha<0) rthha=FLOATERR;
		}
		else
			rthha=FLOATERR;
		break;
	case 1:	// all but Ta
		ta=tjmax-(rthha+rthph+rthjp)*p;
		if (ta>tjmax) ta=FLOATERR;
		break;
	case 2: // all but Tjmax
		tjmax=(rthha+rthph+rthjp)*p+ta;
		break;
	}

	// Put back calculated values
	m_rthha=ToCString(rthha);
	m_rthph=ToCString(rthph);
	m_rthjp=ToCString(rthjp);
	m_ta=ToCString(ta);
	m_p=ToCString(p);
	m_tjmax=ToCString(tjmax);
	UpdateData(FALSE);
}

BOOL CHeatDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_p="10";
	m_rthha="3";
	m_rthph="0.6";
	m_rthjp="2";
	m_ta="25";
	m_tjmax="175";
	m_select=0;
	UpdateData(FALSE);
	Calcul();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
