// RcnotchDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "RcnotchDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRcnotchDlg dialog


CRcnotchDlg::CRcnotchDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRcnotchDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CRcnotchDlg)
	m_c = _T("");
	m_fc = _T("");
	m_r = _T("");
	m_select = -1;
	//}}AFX_DATA_INIT
}


void CRcnotchDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CRcnotchDlg)
	DDX_Text(pDX, IDC_RCNOTCH_C, m_c);
	DDX_Text(pDX, IDC_RCNOTCH_FC, m_fc);
	DDX_Text(pDX, IDC_RCNOTCH_R, m_r);
	DDX_Radio(pDX, IDC_RCNOTCH_RADIO1, m_select);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CRcnotchDlg, CDialog)
	//{{AFX_MSG_MAP(CRcnotchDlg)
	ON_BN_CLICKED(ID_RCNOTCH_HELP, OnRcnotchHelp)
	ON_BN_CLICKED(ID_RCNOTCH_OK, OnRcnotchOk)
	ON_BN_CLICKED(IDC_RCNOTCH_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_RCNOTCH_RADIO2, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CRcnotchDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}
/////////////////////////////////////////////////////////////////////////////
// CRcnotchDlg message handlers

void CRcnotchDlg::OnRcnotchHelp() 
{
	// TODO: Add your control notification handler code here
	WinHelp(HPC_RCNOTCH,HELP_CONTEXT);
}

void CRcnotchDlg::OnRcnotchOk() 
{
	// TODO: Add your control notification handler code here
	CDialog::OnOK();
}

void CRcnotchDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double r,c,fc;

	// Read current values
	UpdateData(TRUE);
	r=fabs(ToDouble(m_r));
	c=fabs(ToDouble(m_c));
	fc=fabs(ToDouble(m_fc));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// r,c
		GetDlgItem(IDC_RCNOTCH_R)->EnableWindow(TRUE);
		GetDlgItem(IDC_RCNOTCH_C)->EnableWindow(TRUE);
		GetDlgItem(IDC_RCNOTCH_FC)->EnableWindow(FALSE);
		break;
	case 1:	// c,f
		GetDlgItem(IDC_RCNOTCH_R)->EnableWindow(FALSE);
		GetDlgItem(IDC_RCNOTCH_C)->EnableWindow(TRUE);
		GetDlgItem(IDC_RCNOTCH_FC)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// r,c
		if ((r>1e-12) && (c>1e-12))
			fc=1/(2*3.1416*r*c);
		else
			fc=FLOATERR;
		break;
	case 1:	// c,fc
		if ((c>1e-12) && (fc>1e-12))
			r=1/(2*3.1416*fc*c);
		else
			fc=FLOATERR;
		break;
	}

	// Put back calculated values
	m_r=ToCString(r);
	m_c=ToCString(c);
	m_fc=ToCString(fc);
	UpdateData(FALSE);

}

BOOL CRcnotchDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_r="2.2k";
	m_c="10n";
	m_fc="1";
	m_select=0;
	UpdateData(FALSE);
	Calcul();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
