// TwocapaDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "TwocapaDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTwocapaDlg dialog


CTwocapaDlg::CTwocapaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTwocapaDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTwocapaDlg)
	m_c = _T("");
	m_c1 = _T("");
	m_c2 = _T("");
	m_select = -1;
	m_serpar = -1;
	m_u = _T("");
	m_u1 = _T("");
	m_u2 = _T("");
	//}}AFX_DATA_INIT
}


void CTwocapaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTwocapaDlg)
	DDX_Text(pDX, IDC_2CAPA_C, m_c);
	DDX_Text(pDX, IDC_2CAPA_C1, m_c1);
	DDX_Text(pDX, IDC_2CAPA_C2, m_c2);
	DDX_Radio(pDX, IDC_2CAPA_RADIO1, m_select);
	DDX_Radio(pDX, IDC_2CAPA_SERPAR1, m_serpar);
	DDX_Text(pDX, IDC_2CAPA_U, m_u);
	DDX_Text(pDX, IDC_2CAPA_U1, m_u1);
	DDX_Text(pDX, IDC_2CAPA_U2, m_u2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTwocapaDlg, CDialog)
	//{{AFX_MSG_MAP(CTwocapaDlg)
	ON_BN_CLICKED(ID_2CAPA_OK, On2capaOk)
	ON_BN_CLICKED(ID_2CAPA_HELP, On2capaHelp)
	ON_BN_CLICKED(IDC_2CAPA_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_2CAPA_RADIO2, Calcul)
	ON_BN_CLICKED(IDC_2CAPA_SERPAR1, Calcul)
	ON_BN_CLICKED(IDC_2CAPA_SERPAR2, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CTwocapaDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CTwocapaDlg message handlers

void CTwocapaDlg::On2capaOk() 
{
	CDialog::OnOK();	
}

void CTwocapaDlg::On2capaHelp() 
{
	WinHelp(HPC_2CAPA,HELP_CONTEXT);	
}

void CTwocapaDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double c1,c2,c,u1,u2,u;

	// Read current values
	UpdateData(TRUE);
	c1=fabs(ToDouble(m_c1));
	c2=fabs(ToDouble(m_c2));
	c=fabs(ToDouble(m_c));
	u1=fabs(ToDouble(m_u1));
	u2=fabs(ToDouble(m_u2));
	u=fabs(ToDouble(m_u));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// c1 & c2
		GetDlgItem(IDC_2CAPA_C1)->EnableWindow(TRUE);
		GetDlgItem(IDC_2CAPA_C2)->EnableWindow(TRUE);
		GetDlgItem(IDC_2CAPA_C)->EnableWindow(FALSE);
		GetDlgItem(IDC_2CAPA_U1)->EnableWindow(FALSE);
		GetDlgItem(IDC_2CAPA_U2)->EnableWindow(FALSE);
		GetDlgItem(IDC_2CAPA_U)->EnableWindow(TRUE);
		break;
	case 1:	// C & C1
		GetDlgItem(IDC_2CAPA_C1)->EnableWindow(TRUE);
		GetDlgItem(IDC_2CAPA_C2)->EnableWindow(FALSE);
		GetDlgItem(IDC_2CAPA_C)->EnableWindow(TRUE);
		GetDlgItem(IDC_2CAPA_U1)->EnableWindow(FALSE);
		GetDlgItem(IDC_2CAPA_U2)->EnableWindow(FALSE);
		GetDlgItem(IDC_2CAPA_U)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// c1&c2
		if (m_serpar==1)
		{ // Parallel
			c=c1+c2;
			u1=u2=u;
		}
		else
		{ // Serial
			if ((c1>1e-12) && (c2>1e-12))
			{
				c=(c1*c2/(c1+c2));
				u1=c2*u/(c1+c2);
				u2=c1*u/(c1+c2);
			}
			else
				c=u1=u2=FLOATERR;
		};
		break;
	case 1:	// c1&c
		if (m_serpar==1)
		{ // Parallel
			if (c-c1>1e-12)
			{
				c2=c-c1;
				u1=u2=u;
			}
			else
				c2=u1=u2=FLOATERR;
		}
		else
		{ // Serial
			if ((c1>1e-12) && (c1-c>1e-12))
			{
				c2=c1*c/(c1-c);
				if (c2>1e-12)
				{
					u1=c2*u/(c1+c2);
					u2=c1*u/(c1+c2);
				}
				else
					u1=u2=FLOATERR;
			}
			else
				c2=u1=u2=FLOATERR;
		};
		break;
	}

	// Put back calculated values
	m_c1=ToCString(c1);
	m_c2=ToCString(c2);
	m_c=ToCString(c);
	m_u1=ToCString(u1);
	m_u2=ToCString(u2);
	m_u=ToCString(u);
	UpdateData(FALSE);
}

BOOL CTwocapaDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_c1="22n";
	m_c2="10n";
	m_c="0";
	m_u1="0";
	m_u2="0";
	m_u="10";
	m_select=0;
	m_serpar=0;
	UpdateData(FALSE);
	Calcul();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
