// 555MonoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "555MonoDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// C555MonoDlg dialog


C555MonoDlg::C555MonoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(C555MonoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(C555MonoDlg)
	m_c = _T("");
	m_r1 = _T("");
	m_select = -1;
	m_t = _T("");
	//}}AFX_DATA_INIT
}


void C555MonoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(C555MonoDlg)
	DDX_Text(pDX, IDC_555MONO_C, m_c);
	DDX_Text(pDX, IDC_555MONO_R1, m_r1);
	DDX_Radio(pDX, IDC_555MONO_RADIO1, m_select);
	DDX_Text(pDX, IDC_555MONO_T, m_t);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(C555MonoDlg, CDialog)
	//{{AFX_MSG_MAP(C555MonoDlg)
	ON_BN_CLICKED(ID_555MONO_HELP, On555monoHelp)
	ON_BN_CLICKED(ID_555MONO_OK, On555monoOk)
	ON_BN_CLICKED(IDC_555MONO_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_555MONO_RADIO2, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL C555MonoDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// C555MonoDlg message handlers

void C555MonoDlg::On555monoHelp() 
{
	// TODO: Add your control notification handler code here
	WinHelp(HPC_555MONO,HELP_CONTEXT);	
}

void C555MonoDlg::On555monoOk() 
{
	// TODO: Add your control notification handler code here
	CDialog::OnOK();
}

void C555MonoDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double r1,c,t;

	// Read current values
	UpdateData(TRUE);
	r1=fabs(ToDouble(m_r1));
	c=fabs(ToDouble(m_c));
	t=fabs(ToDouble(m_t));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// r,c
		GetDlgItem(IDC_555MONO_R1)->EnableWindow(TRUE);
		GetDlgItem(IDC_555MONO_C)->EnableWindow(TRUE);
		GetDlgItem(IDC_555MONO_T)->EnableWindow(FALSE);
		break;
	case 1:	// r,deltat
		GetDlgItem(IDC_555MONO_R1)->EnableWindow(TRUE);
		GetDlgItem(IDC_555MONO_C)->EnableWindow(FALSE);
		GetDlgItem(IDC_555MONO_T)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// r,c
		t=1.1*r1*c;
		break;
	case 1:	// r,deltat
		if (t>1e-12)
		{
			c=t/(1.1*r1);
		}
		else
			c=FLOATERR;
		break;
	}

	// Put back calculated values
	m_r1=ToCString(r1);
	m_c=ToCString(c);
	m_t=ToCString(t);
	UpdateData(FALSE);
	
}

BOOL C555MonoDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_r1="2.2k";
	m_c="10n";
	m_t="1";
	m_select=0;
	UpdateData(FALSE);
	Calcul();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
