// AopschmittDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "AopschmittDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAopschmittDlg dialog


CAopschmittDlg::CAopschmittDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAopschmittDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAopschmittDlg)
	m_r1 = _T("");
	m_r2 = _T("");
	m_select = -1;
	m_upwr = _T("");
	m_utrig = _T("");
	//}}AFX_DATA_INIT
}


void CAopschmittDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAopschmittDlg)
	DDX_Text(pDX, IDC_AOPSCHMITT_R1, m_r1);
	DDX_Text(pDX, IDC_AOPSCHMITT_R2, m_r2);
	DDX_Radio(pDX, IDC_AOPSCHMITT_RADIO1, m_select);
	DDX_Text(pDX, IDC_AOPSCHMITT_UPWR, m_upwr);
	DDX_Text(pDX, IDC_AOPSCHMITT_UTRIG, m_utrig);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAopschmittDlg, CDialog)
	//{{AFX_MSG_MAP(CAopschmittDlg)
	ON_BN_CLICKED(ID_AOPSCHMITT_HELP, OnAopschmittHelp)
	ON_BN_CLICKED(ID_AOPSCHMITT_OK, OnAopschmittOk)
	ON_BN_CLICKED(IDC_AOPSCHMITT_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_AOPSCHMITT_RADIO2, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CAopschmittDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CAopschmittDlg message handlers

void CAopschmittDlg::OnAopschmittHelp() 
{
	// TODO: Add your control notification handler code here
	WinHelp(HPC_AOPSCHMITT,HELP_CONTEXT);
}

void CAopschmittDlg::OnAopschmittOk() 
{
	// TODO: Add your control notification handler code here
	CDialog::OnOK();
}

void CAopschmittDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double r1,r2,upwr,utrig;

	// Read current values
	UpdateData(TRUE);
	r1=fabs(ToDouble(m_r1));
	r2=fabs(ToDouble(m_r2));
	upwr=fabs(ToDouble(m_upwr));
	utrig=fabs(ToDouble(m_utrig));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// r1,r2,upwr
		GetDlgItem(IDC_AOPSCHMITT_R1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPSCHMITT_R2)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPSCHMITT_UPWR)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPSCHMITT_UTRIG)->EnableWindow(FALSE);
		break;
	case 1:	// r2,utrig,upwr
		GetDlgItem(IDC_AOPSCHMITT_R1)->EnableWindow(FALSE);
		GetDlgItem(IDC_AOPSCHMITT_R2)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPSCHMITT_UPWR)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPSCHMITT_UTRIG)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// r1,r2,upwr
		if ((r1>1e-12) && (r2>1e-12) && (upwr>1e-12))
		{
			utrig=r1*upwr/r2;
		}
		else
			utrig=FLOATERR;
		break;
	case 1:	// r2,utrig,upwr
		if ((r2>1e-12) && (utrig>1e-12) && (upwr>1e-12))
		{
			r1=r2*utrig/upwr;
		}
		else
			r1=FLOATERR;
		break;
	}

	// Put back calculated values
	m_r1=ToCString(r1);
	m_r2=ToCString(r2);
	m_utrig=ToCString(utrig);
	m_upwr=ToCString(upwr);
	UpdateData(FALSE);
}

BOOL CAopschmittDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_r1="2.2k";
	m_r2="4.7k";
	m_upwr="12";
	m_utrig="1";
	m_select=0;
	UpdateData(FALSE);
	Calcul();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
