// ClassaDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "ClassaDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CClassaDlg dialog


CClassaDlg::CClassaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CClassaDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CClassaDlg)
	m_beta = _T("");
	m_components = _T("");
	m_freqmin = _T("");
	m_impfixed = FALSE;
	m_maxgain = FALSE;
	m_parameters = _T("");
	m_rc = _T("");
	m_status = _T("");
	m_vcc = _T("");
	m_vin = _T("");
	m_vout = _T("");
	m_rl = _T("");
	//}}AFX_DATA_INIT
}


void CClassaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CClassaDlg)
	DDX_Text(pDX, IDC_CLASSA_BETA, m_beta);
	DDX_LBString(pDX, IDC_CLASSA_COMPONENTS, m_components);
	DDX_Text(pDX, IDC_CLASSA_FREQMIN, m_freqmin);
	DDX_Check(pDX, IDC_CLASSA_IMPFIXED, m_impfixed);
	DDX_Check(pDX, IDC_CLASSA_MAXGAIN, m_maxgain);
	DDX_LBString(pDX, IDC_CLASSA_PARAMETERS, m_parameters);
	DDX_Text(pDX, IDC_CLASSA_RC, m_rc);
	DDX_Text(pDX, IDC_CLASSA_STATUS, m_status);
	DDX_Text(pDX, IDC_CLASSA_VCC, m_vcc);
	DDX_Text(pDX, IDC_CLASSA_VIN, m_vin);
	DDX_Text(pDX, IDC_CLASSA_VOUT, m_vout);
	DDX_Text(pDX, IDC_CLASSA_RL, m_rl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CClassaDlg, CDialog)
	//{{AFX_MSG_MAP(CClassaDlg)
	ON_BN_CLICKED(ID_CLASSA_HELP, OnClassaHelp)
	ON_BN_CLICKED(ID_CLASSA_OK, OnClassaOk)
	ON_BN_CLICKED(IDC_CLASSA_IMPFIXED, Calcul)
	ON_BN_CLICKED(IDC_CLASSA_MAXGAIN, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CClassaDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CClassaDlg message handlers

void CClassaDlg::OnClassaHelp() 
{
	WinHelp(HPC_CLASSA,HELP_CONTEXT);	
}

void CClassaDlg::OnClassaOk() 
{
	CDialog::OnOK();	
}

void CClassaDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double b,f,rc,vcc,vi,vo,rl;
	double mv,j,vp,g,gd,ie,re,iq,ib,rp,vt,ve,vv,gt,rv,vb;
	double rb,rx,zi,ci,cb,ra,rr,im,rk,al,vk,cl;
	int fl,nf,cpt;

	CListBox *pList;
	
	// Read current values
	UpdateData(TRUE);
	b=fabs(ToDouble(m_beta));
	f=fabs(ToDouble(m_freqmin));
	rc=fabs(ToDouble(m_rc));
	vcc=fabs(ToDouble(m_vcc));
	vi=fabs(ToDouble(m_vin));
	vo=fabs(ToDouble(m_vout));
	rl=fabs(ToDouble(m_rl));
	
	// Put calculated fields unaccessible
	GetDlgItem(IDC_CLASSA_VOUT)->EnableWindow(m_maxgain ? FALSE : TRUE);
	GetDlgItem(IDC_CLASSA_RL)->EnableWindow(m_impfixed ? TRUE : FALSE);
		
	// Calculate

	fl=0;
	nf=0;
	mv = .5; 
	j = 10; 
	vp = .03; 
	rk = rc * rl / (rc + rl); 

	if (!m_impfixed)
		rl=999999;

	if (m_maxgain)
		vo = b * vi; 

	g = vo / vi;
  
	if (g > b)
	{
		g = b; 
	    vo = b * vi;
	    fl = 1;
	};
     
	if (vo > vcc - vi - mv)
	{
		vo = vcc - vi - mv;
	    g = vo / vi;
	    fl = 3;
	};
	
	gd = g;
	al = b / (b + 1); 

	cpt=0;

l580:

	cpt++;
	if (cpt>1000)
	{
		nf=1;
		goto lout;
	}

	ie = 0;
    re = 0;

	if (vo < vi)
		nf = 1;
	else
	{
		iq = .5 * (vo + 2 * mv) / rk; 
		ib = iq / b; 
		ie = iq + ib; 
		rp = vp / ie; 
		re = al * rk / g - rp; 
		if (re <  - .1)
		{
			g = al * rk / rp;
			fl = 2;
			vo = g * vi;
			goto l580;
		}
       
		if (re < 0) re = 0;
		vt = iq * rk + ie * re; 
		vk = vcc - iq * rc; 
		ve = vk - vt - vp; 
		if (ve >= vi / 2)
			;
		else
		{
			if (ve < vi / 2)
			{	
				vo = vo * .95; 
				g = vo / vi;
				fl = 3;
				goto l580;
			}
		}
       
		vv = ve - ie * re; 
		if (vv < .0001)
		{
			vo = vo + vv;
			g = vo / vi;
			fl = 3;
			goto l580;
		}
       
		if (vv < 0) vv = 0;
  
		if ((fl == 2) && (g > gt))
		{
			mv = mv + vv / 4; 
			gt = g;
			g = gd;
			vo = g * vi;
			fl = 0;
			goto l580;
		}
       
		rv = vv / ie; 
		vb = ve + .7; 
		rb = (vcc - vb) / ((j + 1) * ib); 
		rx = vb / (j * ib); 
		zi = 1 / (1 / rx + 1 / rb + al / (b * (re + rp))); 
		ci =  1 / (2 * 3.1415927 * f * zi);

		if (rv < 1)
			cb = 0;
		else
		{
			ra = re + rp + (rb * rx) / (b * (rb + rx)); 
			rr = ra * rv / (ra + rv);
			cb =  1 / (2 * 3.1415927 * f * rr);
		}
 
		cl =  1 / (2 * 3.1415927 * f * rl);
	}

	im = 0; 
	if (rv < 0) nf = 2;
 
	// display status
lout:

	if (nf==1)
		m_status="Non operating conditions ! Lower Vin or raise Vcc.";  
	else if (nf==2)
		m_status="Non operating conditions ! Lower Vout or raise Vcc.";
	else switch(fl)
	{
		case 0 :
			m_status="Ok !";
			break;
		case 1 :
			m_status="Gain reduced by low transistor beta.";
			break;
		case 2:
			m_status="Gain reduced by output impedance.";
			break;
		case 3:
			m_status="Gain reduced by low Vcc.";
	}
            
	// display components values
	pList=(CListBox*)GetDlgItem(IDC_CLASSA_COMPONENTS);
	GetDlgItem(IDC_CLASSA_COMPONENTS)->SendMessage(LB_RESETCONTENT,0,0);
	
	if (nf==0)
	{
		pList->AddString("Resistors :");
		pList->AddString("");
		pList->AddString("Rc = "+ToCString(rc)+" ohm");
		pList->AddString("Re = "+ToCString(re)+" ohm");
		pList->AddString("Rv = "+ToCString(rv)+" ohm");
		pList->AddString("Rb = "+ToCString(rb)+" ohm");
		pList->AddString("Rx = "+ToCString(rx)+" ohm");
		pList->AddString("");
		pList->AddString("Capacitors :");
		pList->AddString("Cin  = "+ToCString(ci)+" F");
		pList->AddString("Cout = "+ToCString(cl)+" F");
		pList->AddString("Cby  = "+ToCString(cb)+" F");
	}
	else
	{
		pList->AddString("Non operating !");
	}
 
	// display operating parameters
 	pList=(CListBox*)GetDlgItem(IDC_CLASSA_PARAMETERS);
	GetDlgItem(IDC_CLASSA_PARAMETERS)->SendMessage(LB_RESETCONTENT,0,0);
	
	if (nf==0)
	{
		pList->AddString("Impedances :");
		pList->AddString("");
		pList->AddString("in = "+ToCString(zi)+" ohm");
		pList->AddString("out= "+ToCString(rc)+" ohm");
		pList->AddString("w/l= "+ToCString(rk)+" ohm");
		pList->AddString("");
		pList->AddString("Quiescent current :");
		pList->AddString("C = "+ToCString(iq)+" A");
		pList->AddString("B = "+ToCString(ib)+" A");
		pList->AddString("");
		pList->AddString("Quiescent voltages :");
		pList->AddString("Vcc = "+ToCString(vcc)+" V");
		pList->AddString("C = "+ToCString(vk)+" V");
		pList->AddString("E = "+ToCString(ve)+" V");
		pList->AddString("B = "+ToCString(vb)+" V");
		pList->AddString("");
		pList->AddString("Signal voltages :");
		pList->AddString("Inp = "+ToCString(vi)+" V");
		pList->AddString("Out = "+ToCString(vi*g)+" V");
		pList->AddString("Gain= "+ToCString(g));
		pList->AddString("");
		pList->AddString("Max power :");
		pList->AddString("Pmax= "+ToCString(vt*iq)+" W");
	}
	else
	{
		pList->AddString("Non operating !");
	}
	
	// Put back calculated values
	m_beta=ToCString(b);
	m_freqmin=ToCString(f);
	m_rc=ToCString(rc);
	m_vcc=ToCString(vcc);
	m_vin=ToCString(vi);
	m_vout=ToCString(vo);
	m_rl=ToCString(rl);
	UpdateData(FALSE);
}

BOOL CClassaDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_beta="100";
	m_freqmin="20";
	m_rc="220";
	m_impfixed=FALSE;
	m_maxgain=TRUE;
	m_vcc="12";
	m_vin="100m";
	m_vout="1";
	m_rl="47K";
	m_status="Not calculated yet";
	UpdateData(FALSE);
	Calcul();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
