// CmosastaDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "CmosastaDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCmosastaDlg dialog


CCmosastaDlg::CCmosastaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCmosastaDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCmosastaDlg)
	m_c = _T("");
	m_f = _T("");
	m_r1 = _T("");
	m_select = -1;
	m_t = _T("");
	//}}AFX_DATA_INIT
}


void CCmosastaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCmosastaDlg)
	DDX_Text(pDX, IDC_CMOSASTA_C, m_c);
	DDX_Text(pDX, IDC_CMOSASTA_F, m_f);
	DDX_Text(pDX, IDC_CMOSASTA_R1, m_r1);
	DDX_Radio(pDX, IDC_CMOSASTA_RADIO1, m_select);
	DDX_Text(pDX, IDC_CMOSASTA_T, m_t);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCmosastaDlg, CDialog)
	//{{AFX_MSG_MAP(CCmosastaDlg)
	ON_BN_CLICKED(ID_CMOSASTA_HELP, OnCmosastaHelp)
	ON_BN_CLICKED(ID_CMOSASTA_OK, OnCmosastaOk)
	ON_BN_CLICKED(IDC_CMOSASTA_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_CMOSASTA_RADIO2, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CCmosastaDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}
/////////////////////////////////////////////////////////////////////////////
// CCmosastaDlg message handlers

void CCmosastaDlg::OnCmosastaHelp() 
{
	// TODO: Add your control notification handler code here
	WinHelp(HPC_CMOSASTA,HELP_CONTEXT);	
}

void CCmosastaDlg::OnCmosastaOk() 
{
	// TODO: Add your control notification handler code here
	CDialog::OnOK();
}

void CCmosastaDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	// TODO: Add your control notification handler code here
	double r1,c,f,t;

	// Read current values
	UpdateData(TRUE);
	r1=fabs(ToDouble(m_r1));
	c=fabs(ToDouble(m_c));
	f=fabs(ToDouble(m_f));
	t=fabs(ToDouble(m_t));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// r,c
		GetDlgItem(IDC_CMOSASTA_R1)->EnableWindow(TRUE);
		GetDlgItem(IDC_CMOSASTA_C)->EnableWindow(TRUE);
		GetDlgItem(IDC_CMOSASTA_T)->EnableWindow(FALSE);
		GetDlgItem(IDC_CMOSASTA_F)->EnableWindow(FALSE);
		break;
	case 1:	// r,deltat
		GetDlgItem(IDC_CMOSASTA_R1)->EnableWindow(TRUE);
		GetDlgItem(IDC_CMOSASTA_C)->EnableWindow(FALSE);
		GetDlgItem(IDC_CMOSASTA_T)->EnableWindow(TRUE);
		GetDlgItem(IDC_CMOSASTA_F)->EnableWindow(FALSE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// r,c
		t=0.7*r1*c;
		break;
	case 1:	// r,deltat
		if (t>1e-12)
		{
			c=t/(0.7*r1);
		}
		else
			c=FLOATERR;
		break;
	}

	if (t>1e-12)
		f=1/t;
	else
		f=FLOATERR;

	// Put back calculated values
	m_r1=ToCString(r1);
	m_c=ToCString(c);
	m_t=ToCString(t);
	m_f=ToCString(f);
	UpdateData(FALSE);

}

BOOL CCmosastaDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_r1="2.2k";
	m_c="10n";
	m_t="1";
	m_select=0;
	UpdateData(FALSE);
	Calcul();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
