// CylselfDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "CylselfDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCylselfDlg dialog


CCylselfDlg::CCylselfDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCylselfDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCylselfDlg)
	m_d = _T("");
	m_l = _T("");
	m_n = _T("");
	m_p = _T("");
	m_select = -1;
	//}}AFX_DATA_INIT
}


void CCylselfDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCylselfDlg)
	DDX_Text(pDX, IDC_CYLSELF_D, m_d);
	DDX_Text(pDX, IDC_CYLSELF_L, m_l);
	DDX_Text(pDX, IDC_CYLSELF_N, m_n);
	DDX_Text(pDX, IDC_CYLSELF_P, m_p);
	DDX_Radio(pDX, IDC_CYLSELF_RADIO1, m_select);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCylselfDlg, CDialog)
	//{{AFX_MSG_MAP(CCylselfDlg)
	ON_BN_CLICKED(ID_CYLSELF_OK, OnCylselfOk)
	ON_BN_CLICKED(ID_CYLSELF_HELP, OnCylselfHelp)
	ON_BN_CLICKED(IDC_CYLSELF_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_CYLSELF_RADIO2, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CCylselfDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CCylselfDlg message handlers

void CCylselfDlg::OnCylselfOk() 
{
	CDialog::OnOK();	
}

void CCylselfDlg::OnCylselfHelp() 
{
	WinHelp(HPC_CYLSELF,HELP_CONTEXT);	
}

void CCylselfDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double l,n,d,p;

	// Read current values
	UpdateData(TRUE);
	l=fabs(ToDouble(m_l));
	n=fabs(ToDouble(m_n));
	d=fabs(ToDouble(m_d));
	p=fabs(ToDouble(m_p));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// n,d,p
		GetDlgItem(IDC_CYLSELF_L)->EnableWindow(FALSE);
		GetDlgItem(IDC_CYLSELF_N)->EnableWindow(TRUE);
		GetDlgItem(IDC_CYLSELF_D)->EnableWindow(TRUE);
		GetDlgItem(IDC_CYLSELF_P)->EnableWindow(TRUE);
		break;
	case 1:	// l,d,p
		GetDlgItem(IDC_CYLSELF_L)->EnableWindow(TRUE);
		GetDlgItem(IDC_CYLSELF_N)->EnableWindow(FALSE);
		GetDlgItem(IDC_CYLSELF_D)->EnableWindow(TRUE);
		GetDlgItem(IDC_CYLSELF_P)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// n,d,p
		if((d>1e-12))
			l=1e-8*d*d*n*n/(40*d+110*p);
		else
			l=FLOATERR;
		break;
	case 1:	// l,d,p
		if((d>1e-12))
			n=sqrt(l*(40*d+110*p)/(1e-8*d*d));
		else
			n=FLOATERR;
		break;
	}

	// Put back calculated values
	m_l=ToCString(l);
	m_d=ToCString(d);
	m_n=ToCString(n);
	m_p=ToCString(p);
	UpdateData(FALSE);
}

BOOL CCylselfDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_l="1";
	m_p="10m";
	m_d="5m";
	m_n="100";
	m_select=0;
	UpdateData(FALSE);
	Calcul();
		
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
