// MultiselfDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "MultiselfDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMultiselfDlg dialog


CMultiselfDlg::CMultiselfDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMultiselfDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMultiselfDlg)
	m_d = _T("");
	m_e = _T("");
	m_l = _T("");
	m_n = _T("");
	m_p = _T("");
	m_select = -1;
	//}}AFX_DATA_INIT
}


void CMultiselfDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMultiselfDlg)
	DDX_Text(pDX, IDC_MULTISELF_D, m_d);
	DDX_Text(pDX, IDC_MULTISELF_E, m_e);
	DDX_Text(pDX, IDC_MULTISELF_L, m_l);
	DDX_Text(pDX, IDC_MULTISELF_N, m_n);
	DDX_Text(pDX, IDC_MULTISELF_P, m_p);
	DDX_Radio(pDX, IDC_MULTISELF_RADIO1, m_select);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMultiselfDlg, CDialog)
	//{{AFX_MSG_MAP(CMultiselfDlg)
	ON_BN_CLICKED(ID_MULTISELF_HELP, OnMultiselfHelp)
	ON_BN_CLICKED(ID_MULTISELF_OK, OnMultiselfOk)
	ON_BN_CLICKED(IDC_MULTISELF_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_MULTISELF_RADIO2, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CMultiselfDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CMultiselfDlg message handlers

void CMultiselfDlg::OnMultiselfHelp() 
{
	WinHelp(HPC_MULTISELF,HELP_CONTEXT);	
}

void CMultiselfDlg::OnMultiselfOk() 
{
	CDialog::OnOK();
}

void CMultiselfDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double l,n,d,p,e;

	// Read current values
	UpdateData(TRUE);
	l=fabs(ToDouble(m_l));
	n=fabs(ToDouble(m_n));
	d=fabs(ToDouble(m_d));
	p=fabs(ToDouble(m_p));
	e=fabs(ToDouble(m_e));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// n,d,p,e
		GetDlgItem(IDC_MULTISELF_L)->EnableWindow(FALSE);
		GetDlgItem(IDC_MULTISELF_N)->EnableWindow(TRUE);
		GetDlgItem(IDC_MULTISELF_D)->EnableWindow(TRUE);
		GetDlgItem(IDC_MULTISELF_P)->EnableWindow(TRUE);
		GetDlgItem(IDC_MULTISELF_E)->EnableWindow(TRUE);
		break;
	case 1:	// l,d,p,e
		GetDlgItem(IDC_MULTISELF_L)->EnableWindow(TRUE);
		GetDlgItem(IDC_MULTISELF_N)->EnableWindow(FALSE);
		GetDlgItem(IDC_MULTISELF_D)->EnableWindow(TRUE);
		GetDlgItem(IDC_MULTISELF_P)->EnableWindow(TRUE);
		GetDlgItem(IDC_MULTISELF_E)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// n,d,p,e
		if((d>1e-12))
			l=0.08*1e-8*d*d*n*n/(3*d+9*p+10*e);
		else
			l=FLOATERR;
		break;
	case 1:	// l,d,p,e
		if((d>1e-12))
			n=sqrt(l*(3*d+9*p+10*e)/(0.08*1e-8*d*d));
		else
			n=FLOATERR;
		break;
	}

	// Put back calculated values
	m_l=ToCString(l);
	m_d=ToCString(d);
	m_n=ToCString(n);
	m_p=ToCString(p);
	m_e=ToCString(e);
	UpdateData(FALSE);
}

BOOL CMultiselfDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_p="10m";
	m_d="5m";
	m_e="1m";
	m_n="100";
	m_select=0;
	UpdateData(FALSE);
	Calcul();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
