// PcbselfDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "PcbselfDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPcbselfDlg dialog


CPcbselfDlg::CPcbselfDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPcbselfDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPcbselfDlg)
	m_d1 = _T("");
	m_d2 = _T("");
	m_l = _T("");
	m_n = _T("");
	m_select = -1;
	//}}AFX_DATA_INIT
}


void CPcbselfDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPcbselfDlg)
	DDX_Text(pDX, IDC_PCBSELF_D1, m_d1);
	DDX_Text(pDX, IDC_PCBSELF_D2, m_d2);
	DDX_Text(pDX, IDC_PCBSELF_L, m_l);
	DDX_Text(pDX, IDC_PCBSELF_N, m_n);
	DDX_Radio(pDX, IDC_PCBSELF_RADIO1, m_select);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPcbselfDlg, CDialog)
	//{{AFX_MSG_MAP(CPcbselfDlg)
	ON_BN_CLICKED(ID_PCBSELF_HELP, OnPcbselfHelp)
	ON_BN_CLICKED(ID_PCBSELF_OK, OnPcbselfOk)
	ON_BN_CLICKED(IDC_PCBSELF_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_PCBSELF_RADIO2, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CPcbselfDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CPcbselfDlg message handlers

void CPcbselfDlg::OnPcbselfHelp() 
{
	WinHelp(HPC_PCBSELF,HELP_CONTEXT);	
}

void CPcbselfDlg::OnPcbselfOk() 
{
	CDialog::OnOK();
}

void CPcbselfDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double l,n,d1,d2;

	// Read current values
	UpdateData(TRUE);
	l=fabs(ToDouble(m_l));
	n=fabs(ToDouble(m_n));
	d1=fabs(ToDouble(m_d1));
	d2=fabs(ToDouble(m_d2));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// n,d1,d2
		GetDlgItem(IDC_PCBSELF_L)->EnableWindow(FALSE);
		GetDlgItem(IDC_PCBSELF_N)->EnableWindow(TRUE);
		GetDlgItem(IDC_PCBSELF_D1)->EnableWindow(TRUE);
		GetDlgItem(IDC_PCBSELF_D1)->EnableWindow(TRUE);
		break;
	case 1:	// l,d1,d2
		GetDlgItem(IDC_PCBSELF_L)->EnableWindow(TRUE);
		GetDlgItem(IDC_PCBSELF_N)->EnableWindow(FALSE);
		GetDlgItem(IDC_PCBSELF_D1)->EnableWindow(TRUE);
		GetDlgItem(IDC_PCBSELF_D2)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// n,d1,D2
		if((d2>1e-12) && (d2-d1>1e-12))
			l=1e-9*(d1+d2)*pow(n,5.0/3.0)*log((4*d2+d1)/(d2-d1))/72.0;
		else
			l=FLOATERR;
		break;
	case 1:	// l,d1,d2
		if((d2>1e-12) && (d2-d1>1e-12))
			n=pow(72.0*l/(1e-9*(d2+d1)*log((4*d2+d1)/(d2-d1))),3.0/5.0);
		else
			n=FLOATERR;
		break;
	}

	// Put back calculated values
	m_l=ToCString(l);
	m_d1=ToCString(d1);
	m_n=ToCString(n);
	m_d2=ToCString(d2);
	UpdateData(FALSE);
	
}

BOOL CPcbselfDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_l="1";
	m_d2="10m";
	m_d1="5m";
	m_n="100";
	m_select=0;
	UpdateData(FALSE);
	Calcul();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
