// ZenerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "ZenerDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CZenerDlg dialog


CZenerDlg::CZenerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CZenerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CZenerDlg)
	m_icmax = _T("");
	m_pzmax = _T("");
	m_r = _T("");
	m_select = -1;
	m_rcmin = _T("");
	m_umax = _T("");
	m_umin = _T("");
	m_uz = _T("");
	//}}AFX_DATA_INIT
}


void CZenerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CZenerDlg)
	DDX_Text(pDX, IDC_ZENER_ICMAX, m_icmax);
	DDX_Text(pDX, IDC_ZENER_PZMAX, m_pzmax);
	DDX_Text(pDX, IDC_ZENER_R, m_r);
	DDX_Radio(pDX, IDC_ZENER_RADIO1, m_select);
	DDX_Text(pDX, IDC_ZENER_RCMIN, m_rcmin);
	DDX_Text(pDX, IDC_ZENER_UMAX, m_umax);
	DDX_Text(pDX, IDC_ZENER_UMIN, m_umin);
	DDX_Text(pDX, IDC_ZENER_UZ, m_uz);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CZenerDlg, CDialog)
	//{{AFX_MSG_MAP(CZenerDlg)
	ON_BN_CLICKED(ID_ZENER_HELP, OnZenerHelp)
	ON_BN_CLICKED(ID_ZENER_OK, OnZenerOk)
	ON_BN_CLICKED(IDC_ZENER_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_ZENER_RADIO2, Calcul)
	ON_BN_CLICKED(IDC_ZENER_RADIO3, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CZenerDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CZenerDlg message handlers

void CZenerDlg::OnZenerHelp() 
{
	WinHelp(HPC_ZENER,HELP_CONTEXT);	
}

void CZenerDlg::OnZenerOk() 
{
	CDialog::OnOK();	
}

void CZenerDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
double umin,umax,r,uz,pzmax,icmax,rcmin;

	// Read current values
	UpdateData(TRUE);
	icmax=fabs(ToDouble(m_icmax));
	pzmax=fabs(ToDouble(m_pzmax));
	r=fabs(ToDouble(m_r));
	rcmin=fabs(ToDouble(m_rcmin));
	umax=fabs(ToDouble(m_umax));
	umin=fabs(ToDouble(m_umin));
	uz=fabs(ToDouble(m_uz));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// umax,umin,uz,pmax
		GetDlgItem(IDC_ZENER_ICMAX)->EnableWindow(FALSE);
		GetDlgItem(IDC_ZENER_PZMAX)->EnableWindow(TRUE);
		GetDlgItem(IDC_ZENER_R)->EnableWindow(FALSE);
		GetDlgItem(IDC_ZENER_RCMIN)->EnableWindow(FALSE);
		GetDlgItem(IDC_ZENER_UMAX)->EnableWindow(TRUE);
		GetDlgItem(IDC_ZENER_UMIN)->EnableWindow(TRUE);
		GetDlgItem(IDC_ZENER_UZ)->EnableWindow(TRUE);
		break;
	case 1:	// umax,umin,uz,icmax
		GetDlgItem(IDC_ZENER_ICMAX)->EnableWindow(TRUE);
		GetDlgItem(IDC_ZENER_PZMAX)->EnableWindow(FALSE);
		GetDlgItem(IDC_ZENER_R)->EnableWindow(FALSE);
		GetDlgItem(IDC_ZENER_RCMIN)->EnableWindow(FALSE);
		GetDlgItem(IDC_ZENER_UMAX)->EnableWindow(TRUE);
		GetDlgItem(IDC_ZENER_UMIN)->EnableWindow(TRUE);
		GetDlgItem(IDC_ZENER_UZ)->EnableWindow(TRUE);
		break;
	case 2: // r,uz,icmax,pmax
		GetDlgItem(IDC_ZENER_ICMAX)->EnableWindow(TRUE);
		GetDlgItem(IDC_ZENER_PZMAX)->EnableWindow(TRUE);
		GetDlgItem(IDC_ZENER_R)->EnableWindow(TRUE);
		GetDlgItem(IDC_ZENER_RCMIN)->EnableWindow(FALSE);
		GetDlgItem(IDC_ZENER_UMAX)->EnableWindow(FALSE);
		GetDlgItem(IDC_ZENER_UMIN)->EnableWindow(FALSE);
		GetDlgItem(IDC_ZENER_UZ)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// umax,umin,uz,pmax
		if ((umax>umin) && (umin>uz) && (uz>1e-12) && (pzmax>1e-12))
		{
			r=uz*(umax-uz)/pzmax;
			rcmin=r*uz/(umin-uz);
			icmax=uz/rcmin;
		}
		else r=rcmin=icmax=FLOATERR;
		break;
	case 1:	// umax,umin,uz,icmax
		if ((umax>umin) && (umin>uz) && (uz>1e-12) && (icmax>1e-12))
		{
			rcmin=uz/icmax;
			r=rcmin*(umin-uz)/uz;
			pzmax=uz*(umax-uz)/r;
		}
		else rcmin=r=pzmax=FLOATERR;
		break;
	case 2: // r,uz,icmax,pmax
		if ((uz>1e-12) && (icmax>1e-12))
		{
			rcmin=uz/icmax;
			umin=uz+r*uz/rcmin;
			umax=uz+r*pzmax/uz;
			if (umax-umin<1e-12)
				rcmin=umin=umax=FLOATERR;
		}
		else rcmin=umin=umax=FLOATERR;
		break;
	}

	// Put back calculated values
	m_icmax=ToCString(icmax);
	m_pzmax=ToCString(pzmax);
	m_r=ToCString(r);
	m_rcmin=ToCString(rcmin);
	m_umax=ToCString(umax);
	m_umin=ToCString(umin);
	m_uz=ToCString(uz);
	UpdateData(FALSE);
}


BOOL CZenerDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_icmax = "10m";
	m_pzmax = "400m";
	m_r = "0";
	m_select = 0;
	m_rcmin = "0";
	m_umax = "13";
	m_umin = "10";
	m_uz = "5.6";
	UpdateData(FALSE);
	Calcul();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
