unit MainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Menus, ComCtrls, Spin, IniFiles, MMSystem,
  Registry, ImgList, Grids, Mask;

type
  TMain = class(TForm)
    MainMenu: TMainMenu;
    M_Action: TMenuItem;
    M_Options: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    M_Port: TMenuItem;
    M_COM1: TMenuItem;
    M_COM2: TMenuItem;
    M_COM3: TMenuItem;
    M_COM4: TMenuItem;
    M_Exit: TMenuItem;
    M_AS: TMenuItem;
    M_PZD: TMenuItem;
    Bevel1: TBevel;
    GB1: TGroupBox;
    EditHiT: TEdit;
    SpinHiT: TUpDown;
    SpinLoT: TUpDown;
    EditLoT: TEdit;
    LoD: TLabel;
    HiD: TLabel;
    BTN_Start_Stop: TButton;
    BTN_Exit: TButton;
    OutMAX: TPanel;
    Label3: TLabel;
    OutAVG: TPanel;
    Label4: TLabel;
    OutMIN: TPanel;
    Label5: TLabel;
    Panel3: TPanel;
    ThermBG: TImage;
    ThermP: TPaintBox;
    GB2: TGroupBox;
    MinT: TLabel;
    MaxT: TLabel;
    EditHiL: TEdit;
    SpinHiL: TUpDown;
    SpinLoL: TUpDown;
    EditLoL: TEdit;
    AutoScale: TCheckBox;
    Timer: TTimer;
    ControlT: TCheckBox;
    N1: TMenuItem;
    M_Start_Stop: TMenuItem;
    N6: TMenuItem;
    M_Reset: TMenuItem;
    N5: TMenuItem;
    M_AutoRun: TMenuItem;
    FrameTemp: TBevel;
    procedure wmSysCommand(var Msg : TMessage); message WM_SYSCOMMAND;
    procedure M_ExitClick(Sender: TObject);
    procedure EditTExit(Sender: TObject);
    procedure EditTKeyPress(Sender: TObject; var Key: Char);
    procedure SpinTClick(Sender: TObject; Button: TUDBtnType);
    procedure FormCreate(Sender: TObject);
    procedure EditTKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure GRPaint(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BTN_Start_StopClick(Sender: TObject);
    procedure SelectPort(Sender: TObject);
    procedure SpinLClick(Sender: TObject; Button: TUDBtnType);
    procedure EditLExit(Sender: TObject);
    procedure EditLKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure EditLKeyPress(Sender: TObject; var Key: Char);
    procedure TimerTimer(Sender: TObject);
    procedure M_ASClick(Sender: TObject);
    procedure ControlTClick(Sender: TObject);
    procedure AutoScaleClick(Sender: TObject);
    procedure N1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure M_PZDClick(Sender: TObject);
    procedure N4Click(Sender: TObject);
    procedure N3Click(Sender: TObject);
    procedure M_ResetClick(Sender: TObject);
    procedure M_AutoRunClick(Sender: TObject);
   public
    procedure EditUpdateT(Edit : TEdit; T : PExtended);
    procedure SpinUpdateT(Edit : TEdit; T : PExtended; But : TUDBtnType);
    procedure EditUpdateL(Edit : TEdit; T : PExtended);
    procedure SpinUpdateL(Edit : TEdit; T : PExtended; But : TUDBtnType);
    procedure UpdateGR;
  end;

  TTemp = object
   private
    FColor     : TColor;
    FFontColor : TColor;
    FSize      : Integer;
    FT         : string;
    procedure SetFontColor(c : TColor);
    procedure SetColor(c : TColor);
    procedure SetSize(s : Integer);
    procedure SetT(s : string);
   public
    property  FontColor : TColor  read FFontColor write SetFontColor;
    property  Color     : TColor  read FColor     write SetColor;
    property  Size      : Integer read FSize      write SetSize;
    property  T         : string  read FT         write SetT;
    procedure Update;
  end;

function  Open_COM (n : Byte) : Boolean;
procedure CreateFileOutput(Init : Boolean);
function  ExtendedToStr(s : Extended) : string;

const
 MainFormCaption = '  VT48';
 ID_ABOUT        = WM_USER + 1;
 __DS1820        = 1;
 __DS18S20       = 2;
 __DS18B20       = 3;
 __UnknownDevice = 255;

var
 Main          : TMain;
 FOut          : TextFile;
 DateFileOut   : TDate;
 InitCOM       : Byte;
 SensorPresent : Boolean = FALSE;
 NameS         : Byte = __UnknownDevice;
 COD1,COD2     : Cardinal;
 COD3,COD4     : Byte;
 PeriodSave    : Byte;
 DataSave      : Boolean;
 FileSave      : string;
 FileType      : Boolean;
 CurPeriod     : Byte = 0;
 NoSave        : Byte = 0;
 SFC           : Boolean = FALSE;
 CurrentPath   : string;
 Samples       : array [0..139,1..3] of Extended;
 NS            : Byte = 0;
 CS            : Byte = 0;
 T_MAX         : Extended = 125;
 T_MIN         : Extended = -55;
 Start         : Byte = 0;
 SignalUse     : Boolean;
 LoT           : Extended = -55;
 HiT           : Extended = 125;
 LoL           : Extended = -55;
 HiL           : Extended = 125;
 TempColor     : TColor;
 NormalColor   : TColor;
 StopColor     : TColor;
 ErrorColor    : TColor;
 LoTColor      : TColor;
 HiTColor      : TColor;
 LPTColor      : TColor;
 HPTColor      : TColor;
 WarningColor  : TColor;
 AutoRun       : Boolean = FALSE;
 T_Error       : Boolean = FALSE;
 WinNT         : Boolean = FALSE;
 Temp          : TTemp;

implementation

uses DS1820, TxRx, ParamsForm, InitSensorForm, PZDForm, AboutForm;

const
 __IllegalChange = #244#151#159#139#137#141#144#209#220#222#155#148#136#217 +
  #140#140#154#215#213#19#221#211#129#129#158#131#134#154#130#19#209#131 +
  #129#133#143#138#153#220#222#221#144#138#70#207#140#136#156#217#16#220 +
  #197#218#142#148#147#138#135#137#70#62#52#120#172#133#131#139#136#223 +
  #223#221#83#131#134#203#140#135#146#212#216#214#21#214#133#148#128#151 +
  #133#158#70#62#52#120#170#139#143#155#139#220#219#203#147#155#70#203#140 +
  #128#153#203#208#19#216#209#143#138#148#138#133#148#138#211#24;

 __Warning = #251#159#134#135#132#138#142#220#19;

 __CodAccess = #244#151#140#142#148#138#157#208#18#217#157#128#70#223#130 +
               #144#133#202#223#211#21#222#77#128#147#148#156#154#141#192#24;
               
 __Error = #247#138#134#138#142#135;

 __SensorUnregistred = #253#146#156#156#140#141#70#212#215#19#148#132#150 +
                       #222#143#137#134#203#192#219#197#218#143#132#158#70 +
                       #137#82#150#219#200#128#139#135#129#70; 

 DecoderKey = '39rnkdgf923sdf;law90354mdsfkrg';

var
 UsedCOM  : Byte = 0;

{$R *.dfm}
{$R warning.res}
{$R ctrlxp.res}

//------------------------------

function Decoder (s : string; coder : Boolean = FALSE) : string;
 var
  i  : Byte;
  ss : string;

 begin
  for i := 1 to Length(s) do
   s [i] := Chr(Ord(s [i]) xor Ord(DecoderKey [i mod 30 + 1]));

  if coder then
   begin
    ss := '';

    for i := 1 to Length(s) do
     ss := ss + '#' + IntToStr(Ord(s [i]));

    Result := ss;
   end
  else
   Result := s;  
 end;

//------------------------------

procedure ErrorCRC32;
 begin
  Application.MessageBox(PChar(Decoder(__IllegalChange)),
  PChar(Decoder(__Warning)),MB_OK or MB_IconError);

  Application.Terminate;
 end;

//------------------------------

procedure TTemp.SetFontColor (c : TColor);
 begin
  if FontColor = c then Exit;
  FFontColor := c;
  Update;
 end;

//------------------------------

procedure TTemp.SetColor (c : TColor);
 begin
  if Color = c then Exit;
  FColor := c;
  Update;
 end;

//------------------------------

procedure TTemp.SetSize (s : Integer);
 begin
  FSize := s;
 end;

//------------------------------

procedure TTemp.SetT (s : string);
 begin
  FT := s;
  Update;
 end;

//------------------------------

procedure TTemp.Update;
 var
  a,b : Integer;
  GR  : TBitmap;

 begin
  GR := TBitmap.Create;
  GR.Width  := Main.FrameTemp.Width - 4;
  GR.Height := Main.FrameTemp.Height - 4;

  with GR.Canvas do
   begin
    Brush.Color := Color;
    Font.Name   := 'Arial';
    Font.Size   := Size;
    Font.Style  := [fsBold];
    Font.Color  := FontColor;
    a := TextWidth(T)  div 2;
    b := TextHeight(T) div 2;
    FillRect(Rect(0,0,GR.Width,GR.Height));
    TextOut(GR.Width div 2 - a,GR.Height div 2 - b,T);
   end;

  Main.Canvas.Draw(Main.FrameTemp.Left + 2,Main.FrameTemp.Top + 2,GR);

  GR.Free;
 end;

//------------------------------

procedure PlayWarning;
 var
  hResource : THandle;
  p         : Pointer;

 begin
  hResource := LoadResource(hInstance,FindResource(hInstance,'WARNING',RT_RCDATA));
  try
   p := LockResource(hResource);

   if p <> nil then
    sndPlaySound(p,SND_MEMORY or SND_ASYNC or SND_LOOP);
  finally
   FreeResource(hResource);
  end;
end;

//------------------------------

procedure TMain.wmSysCommand(var Msg : TMessage);
 begin
  if Msg.wParam = ID_ABOUT then
   begin
    About := TAbout.Create(Application);
    About.ShowModal;
    About.Free;
   end;

  inherited;
 end;

//------------------------------

procedure CreateFileOutput(Init : Boolean);
 begin
  if not DirectoryExists(CurrentPath + 'DATA\') then
   if not CreateDir(CurrentPath + 'DATA\') then
    begin
     Application.MessageBox(PChar('  '#13#13 +
                            CurrentPath + 'DATA\'),
                           '',MB_OK or MB_IconError);
     if Init then Halt else Main.Close;
    end;

  if not FileType then
   begin
    FileSave := DateToStr(Date);
    FileSave [3] := '-';
    FileSave [6] := '-';
    FileSave := CurrentPath + 'DATA\' + FileSave + '.csv';
   end;

  AssignFile(FOut,FileSave);

 {$I-}
  if FileExists(FileSave) then Append(FOut) else ReWrite(FOut);
 {$I+}

  if IOResult <> 0 then
   begin
    Application.MessageBox(PChar('   '#13#10 + FileSave +
                           #13#13#10'   !'),
                           '',MB_OK or MB_IconError);
    if Init then Halt else Main.Close;
   end;
 end;

//------------------------------

function Open_COM (n : Byte) : Boolean;
 var
  i : Byte;

 begin
  Result := FALSE;

  PurgeCOM;
  CloseCOM;

  UsedCOM := 0;

  for i := 1 to 4 do
   Main.M_Port.Items [i - 1].Checked := FALSE;

  if n = 0 then Exit;

  if OpenCOM(PChar(Format('COM%d',[n]))) then
   begin
    UsedCOM := n;

    Main.M_Port.Items [n - 1].Checked := TRUE;

    SetCOMTo(MAXDWORD,0,0,0,0);
    SetModCOM(9600,8,NOPARITY,TWOSTOPBITS,TRUE,FALSE);
   end
  else
   begin
    Application.MessageBox(PChar(Format(' COM%d !',[n])),
                           '',MB_OK or MB_IconError);
    Exit;
   end;

  Result := TRUE;
 end;

//------------------------------

function ExtendedToStr(s : Extended) : string;
 var
  fs : TFormatSettings;

 begin
  GetLocaleFormatSettings(0,fs);
  fs.DecimalSeparator := '.';
  Result := Format('%0.1f',[s],fs);
 end;

//------------------------------

procedure TMain.M_ExitClick(Sender: TObject);
 begin
  Close;
 end;

//------------------------------

procedure TMain.UpdateGR;
 var
  i,j,x   : Byte;
  w,dy    : Word;
  dt,T    : Extended;
  _Lo,_Hi : Extended;
  s       : string;
  GR      : TBitmap;

 function CoordY (s : Extended) : Integer;
  var
   y : Integer;

  begin
   y := Round(211 - (s - _Lo) * (205 / (_Hi - _Lo)));

   if y < 5 then y := 5;
   if y > 212 then y := 212;

   Result := y;
  end;

 begin
  T := Samples [0,1];

  if (Start = 2) and (CS > 0) then
   begin
    if T_Error then
     begin
      Temp.Size := 12;
      Temp.Color := ErrorColor;
      Temp.T := ' !';

      if Timer.Enabled then
       begin
        sndPlaySound(nil,SND_NODEFAULT);
        Timer.Enabled := FALSE;
       end;

      Exit;
     end
    else
     begin
      if ((T < LoL) or (T > HiL)) and SignalUse and ControlT.Checked then
       begin
        if not Timer.Enabled then
         begin
          Application.Restore;

          if T < LoL then WarningColor := LoTColor
           else WarningColor := HiTColor;

          PlayWarning;

          Timer.Enabled := TRUE;
         end;
       end
      else
       if Timer.Enabled then
        begin
         sndPlaySound(nil,SND_NODEFAULT);
         Timer.Enabled := FALSE;
        end;

      Temp.Size := 36;

      if not Timer.Enabled then Temp.Color := NormalColor;

      Temp.T := ExtendedToStr(T) + ' C';

      OutMAX.Caption := ExtendedToStr(T_MAX) + ' C  ';
      OutMIN.Caption := ExtendedToStr(T_MIN) + ' C  ';
      OutAVG.Caption := ExtendedToStr((T_MAX + T_MIN) / 2) + ' C  ';

      with ThermP.Canvas do
       begin
        Pen.Width := 3;
        Pen.Color := $00E0E0E0;
        MoveTo(53,145);
        LineTo(53,7);

        Pen.Width := 1;
        Pen.Color := clLime;

        if ControlT.Checked then
         begin
          if T < LoL then Pen.Color := clBlue;
          if T > HiL then Pen.Color := clRed;
         end;

        Brush.Color := Pen.Color;

        with ThermP do
         Ellipse(Width - 29,Height - 10,Width - 10,Height - 1);

        Pen.Width := 3;

        MoveTo(53,146);

        if T <= 125 then LineTo(53,7 + Round((141 / 180) * (180 - (T + 55))))
         else
          LineTo(53,7);
       end;
     end;
   end
  else
   begin
    if Start = 1 then
     begin
      Temp.Size := 12;
      Temp.Color := NormalColor;
      Temp.T := ' ...'
     end
    else
     if Start = 0 then
      begin
       Temp.Size := 36;
       Temp.Color := StopColor;
       Temp.T := '- - - C';
       Application.Title := ' VT48';
      end;

    with ThermP.Canvas do
     begin
      Pen.Width := 3;
      Pen.Color := $00E0E0E0;
      MoveTo(53,145);
      LineTo(53,7);

      Pen.Width := 1;

      Pen.Color   := $00949494;
      Brush.Color := Pen.Color;

      with ThermP do
       Ellipse(Width - 28,Height - 9,Width - 9,Height);

      Pen.Color   := $00E0E0E0;
      Brush.Color := Pen.Color;

      with ThermP do
       Ellipse(Width - 29,Height - 10,Width - 10,Height - 1);
     end;

    OutMAX.Caption := '- - - C  ';
    OutMIN.Caption := '- - - C  ';
    OutAVG.Caption := '- - - C  ';
   end;

  if AutoScale.Checked then
   begin
    _Lo := T_MIN - 0.5;
    _Hi := T_MAX + 0.5;
    if _Lo < -55 then _Lo := -55;
    if _Hi > 125 then _Hi := 125;
   end
  else
   begin
    _Lo := LoT;
    _Hi := HiT;
   end;

  GR := TBitmap.Create;
  GR.Width  := 600;
  GR.Height := 218;

  with GR.Canvas do
   begin
    Pen.Width := 1;

    Pen.Color := clBtnFace;
    Brush.Color := clBtnFace;
    FillRect(Rect(0,0,GR.Width,GR.Height));

    Pen.Color := clBlack;
    Brush.Color := clBlack;
    FillRect(Rect(40,6,GR.Width,GR.Height - 6));

    w := GR.Width - 45;

    if CS < 139 then x := 0
     else x := (NS * 4) mod (w div 5);

    dy := (GR.Height - 12) div 5;

    dt := (_Hi - _Lo) / 5;

    Pen.Color := clSilver;

    for i := 1 to 5 do
     begin
      //  
      if i < 5 then
       begin
        MoveTo(40,6 + dy * i);
        LineTo(GR.Width - 1,6 + dy * i);
       end;

      //  
      MoveTo(40 + (w div 5 * i - x) mod w,6);
      LineTo(40 + (w div 5 * i - x) mod w,GR.Height - 6);
     end;

    Brush.Color := clBtnFace;
    Pen.Color := clBlack;

    // 
    for i := 0 to 5 do
     begin
      s := ExtendedToStr(_Hi - dt * i);
      MoveTo(33,6 + dy * i);
      LineTo(38,6 + dy * i);
      Main.Canvas.Font.Size := 8;
      TextOut(25 - Main.Canvas.TextWidth(s),dy * i,s);
     end;

    //  
    if CS >= 2 then
     begin
      for j := 1 to 1 + 2 * Ord(ControlT.Checked) do
       for i := CS - 1 downto 1 do
        begin
         Pen.Width := Ord(j = 1) * 2 + 1;

         case j of
          1 : Pen.Color := TempColor;
          2 : Pen.Color := LPTColor;
          3 : Pen.Color := HPTColor;
         end;

         MoveTo(40 + (CS - i) * 4,CoordY(Samples [i - 1,j]));
         LineTo(40 + 2 * Ord(j = 1) + (CS - i - 1) * 4,CoordY(Samples [i,j]));
        end;
     end;

    Pen.Color := clBtnFace;
    MoveTo(39,5);
    LineTo(GR.Width + 1,5);
    LineTo(GR.Width + 1,GR.Height - 6);
    LineTo(39,GR.Height - 6);
    LineTo(39,5);
   end;

  Main.Canvas.Draw(17,7,GR);

  GR.Free;
 end;

//------------------------------

procedure TMain.EditUpdateT(Edit : TEdit; T : PExtended);
 var
  s  : string;
  fs : TFormatSettings;
  p  : Extended;

 begin
  s := Edit.Text;

  if Length(s) > 0 then
   begin
    if s [Length(s)] = '.' then s := s + '0';
    if s [1] = '.' then s := '0' + s;
   end;

  GetLocaleFormatSettings(0,fs);
  fs.DecimalSeparator := '.';

  p := StrToFloatDef(s,1000,fs);

  if (p < -55) or (p > 125)  then
   begin
    Edit.Text := ExtendedToStr(T^);
    Exit;
   end;

  if Edit = EditLoT then
   if (HiT - p) < 1 then
    begin
     Edit.Text := ExtendedToStr(LoT);
     Exit;
    end;

  if Edit = EditHiT then
   if (p - LoT) < 1 then
    begin
     Edit.Text := ExtendedToStr(HiT);
     Exit;
    end;

  T^ := Round(p * 10) / 10;
  Edit.Text := ExtendedToStr(T^);
 end;

//------------------------------

procedure TMain.SpinUpdateT(Edit : TEdit; T : PExtended; But : TUDBtnType);
 begin
  EditUpdateT(Edit,T);

  if (But = btNext) and (T^ < 125) then T^ := T^ + 1;
  if (But = btPrev) and (T^ > -55) then T^ := T^ - 1;

  if Edit = EditLoT then
   if (HiT - T^) < 1 then
    begin
     T^ := T^ - 1;
     Exit;
    end;

  if Edit = EditHiT then
   if (T^ - LoT) < 1 then
    begin
     T^ := T^ + 1;
     Exit;
    end;

  Edit.Text := ExtendedToStr(T^);
  UpdateGR;    
 end;

//------------------------------

procedure TMain.EditTKeyPress(Sender: TObject; var Key: Char);
 var
  p : PExtended;

 begin
  if not (Key in ['0'..'9','.','-',#1..#31]) then Key := #0;

  if Key = #13 then
   begin
    if Sender = EditHiT  then p := @HiT else p := @LoT;
    EditUpdateT(Sender as TEdit,p);
    (Sender as TEdit).SelectAll;
    UpdateGR;
    Key := #0;
   end;
 end;

//------------------------------

procedure TMain.EditTExit(Sender: TObject);
 var
  p : PExtended;

 begin
  if Sender = EditHiT  then p := @HiT else p := @LoT;
  EditUpdateT(Sender as TEdit,p);
 end;

//------------------------------

procedure TMain.SpinTClick(Sender: TObject; Button: TUDBtnType);
 var
  p : PExtended;
  t : TEdit;

 begin
  if Sender = SpinHiT then
   begin
    p := @HiT;
    t := EditHiT;
   end
  else
   begin
    p := @LoT;
    t := EditLoT;
   end;

  SpinUpdateT(t,p,Button);
 end;

//------------------------------

procedure TMain.FormCreate(Sender: TObject);
 var
  i       : Byte;
  tmp     : Extended;
  IniFile : TIniFile;
  SysMenu : THandle;

 begin
  Main.Caption := MainFormCaption;

  SysMenu := GetSystemMenu(Handle,FALSE);
  InsertMenu(SysMenu,Word(-1),MF_SEPARATOR,ID_ABOUT,'');
  InsertMenu(SysMenu,Word(-1),MF_BYPOSITION,ID_ABOUT,' ...');

  for i := 0 to 139 do
   Samples [i,1] := 1000;

  CurrentPath := ExtractFilePath(ParamStr(0));

  IniFile := TIniFile.Create(CurrentPath + 'VT48.ini');

  with IniFile do
   begin
    SignalUse := ReadBool('GENERAL','SignalUse',TRUE);
    ControlT.Checked  := ReadBool('GENERAL','ControlT',TRUE);
    AutoScale.Checked := ReadBool('GENERAL','AutoScale',TRUE);
    AutoRun := ReadBool('GENERAL','AutoRun',FALSE);
    InitCOM := ReadInteger('GENERAL','PORT',1);

    TempColor      := ReadInteger('COLORS','TempColor',$000080FF);
    Temp.FontColor := ReadInteger('COLORS','TempValueColor',clBlack);
    NormalColor    := ReadInteger('COLORS','NormalColor',$00C4FFC4);
    StopColor      := ReadInteger('COLORS','StopColor',$00E7CEFF);
    ErrorColor     := ReadInteger('COLORS','ErrorColor',$00FFB7B7);
    LoTColor       := ReadInteger('COLORS','LoTColor',$00FFA953);
    HiTColor       := ReadInteger('COLORS','HiTColor',$00B366FF);
    LPTColor       := ReadInteger('COLORS','LPTColor',clBlue);
    HPTColor       := ReadInteger('COLORS','HPTColor',clRed);

    LoT := ReadFloat('LIMITS','LoT',-55);
    HiT := ReadFloat('LIMITS','HiT',125);

    LoL := ReadFloat('LEVELS','LoL',-55);
    HiL := ReadFloat('LEVELS','HiL',125);

    DataSave   := ReadBool('DATA','Save',TRUE);
    PeriodSave := ReadInteger('DATA','PeriodSave',1);
    FileType   := ReadBool('DATA','FileType',FALSE);
    FileSave   := ReadString('DATA','FileSave','');

    if not (InitCOM in [1..4]) then InitCOM := 1;

    PeriodSave := (PeriodSave div 2) * 2;

    if PeriodSave > 30 then PeriodSave := 30;
    if PeriodSave < 1  then PeriodSave := 1;
   end;

  IniFile.Free;

  //    
  if (LoT < -55) or (LoT > 124) then LoT := -55;
  if (HiT < -54) or (HiT > 125) then HiT := 125;

  if LoT > HiT then
   begin
    tmp := LoT;
    LoT := HiT;
    HiT := tmp;
   end;

  if HiT - LoT < 1 then
   begin
    LoT := -55;
    HiT := 125;
   end;

  //---

  if (LoL < -55) or (LoL > 124) then LoL := -55;
  if (HiL < -54) or (HiL > 125) then HiL := 125;

  if LoL > HiL then
   begin
    tmp := LoL;
    LoL := HiL;
    HiL := tmp;
   end;

  if HiL - LoL < 1 then
   begin
    LoL := -55;
    HiL := 125;
   end;

  EditHiT.Text := ExtendedToStr(HiT);
  EditLoT.Text := ExtendedToStr(LoT);

  EditHiL.Text := ExtendedToStr(HiL);
  EditLoL.Text := ExtendedToStr(LoL);

  LoD.Font.Color  := LPTColor;
  HiD.Font.Color  := HPTColor;
  MinT.Font.Color := LPTColor;
  MaxT.Font.Color := HPTColor;

  M_AS.Checked := SignalUse;
  M_AutoRun.Checked := AutoRun;

  ControlTClick(Sender);
  AutoScaleClick(Sender);

  for i := 1 to 4 do
   M_Port.Items [i - 1].Enabled := AccessCOM(PChar(Format('COM%d',[i])));

  UpdateGR;

  if DataSave then CreateFileOutput(TRUE);
 end;

//------------------------------

procedure TMain.EditTKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
 var
  b : TUDBtnType;
  p : PExtended;

 begin
  if (Shift = []) and (Key in [VK_Up,VK_Down]) then
   begin
    if Key = VK_Up then b := btNext else b := btPrev;

    if Sender = EditLoT then p := @LoT else p := @HiT;

    SpinUpdateT(Sender as TEdit,p,b);

    Key := 0;
   end;
 end;

//------------------------------

procedure TMain.GRPaint(Sender: TObject);
 begin
  UpdateGR;
 end;

//------------------------------

procedure TMain.FormClose(Sender: TObject; var Action: TCloseAction);
 var
  IniFile : TIniFile;
  reg     : TRegistry;

 begin
  if Start > 0 then
   begin
    Start := 0;
    Screen.Cursor := crHourGlass;

    while Start <> 3 do
     Application.ProcessMessages;

    Screen.Cursor := crDefault;
   end;

  if DataSave then CloseFile(FOut);

  reg := TRegistry.Create;

  reg.RootKey := HKEY_CURRENT_USER;

  with reg do
   begin
    OpenKey('\SOFTWARE\VT48\Information',TRUE);
    WriteString('Autor','Frolov Dmitriy');
    WriteString('Copyright','(c) 2004 FDA');
    WriteString('E-mail','*********************');
    WriteString('Product','Virtual thermometr VT48');
    WriteString('Version','1.0');
    WriteString('Web-Site','*********************');

    CloseKey;
   end;

  reg.Free;

  SetModCOM(115200,8,NOPARITY,ONESTOPBIT,FALSE,FALSE);
  PurgeCOM;
  CloseCOM;

  if UsedCOM = 0 then UsedCOM := InitCOM;

  IniFile := TIniFile.Create(CurrentPath + 'VT48.ini');

  with IniFile do
   begin
    WriteBool('GENERAL','SignalUse',SignalUse);
    WriteBool('GENERAL','ControlT',ControlT.Checked);
    WriteBool('GENERAL','AutoScale',AutoScale.Checked);
    WriteBool('GENERAL','AutoRun',AutoRun);
    WriteInteger('GENERAL','PORT',UsedCOM);

    WriteInteger('COLORS','TempColor',TempColor);
    WriteInteger('COLORS','TempValueColor',Temp.FontColor);
    WriteInteger('COLORS','NormalColor',NormalColor);
    WriteInteger('COLORS','StopColor',StopColor);
    WriteInteger('COLORS','ErrorColor',ErrorColor);
    WriteInteger('COLORS','LoTColor',LoTColor);
    WriteInteger('COLORS','HiTColor',HiTColor);
    WriteInteger('COLORS','LPTColor',LPTColor);
    WriteInteger('COLORS','HPTColor',HPTColor);

    WriteFloat('LIMITS','LoT',LoT);
    WriteFloat('LIMITS','HiT',HiT);

    WriteFloat('LEVELS','LoL',LoL);
    WriteFloat('LEVELS','HiL',HiL);

    WriteBool('DATA','Save',DataSave);
    WriteInteger('DATA','PeriodSave',PeriodSave);
    WriteBool('DATA','FileType',FileType);
    WriteString('DATA','FileSave',FileSave);
   end;

  IniFile.Free;
 end;

//------------------------------

procedure TMain.BTN_Start_StopClick(Sender: TObject);
 var
  TH,TL,CnfReg : Byte;

 begin
  if Start = 0 then
   begin
    if not SensorPresent then
     begin
      InitSensor := TInitSensor.Create(Application);
      InitSensor.ShowModal;
      InitSensor.Free;
     end;

    if not SensorPresent then
     if Application.MessageBox('  .'#13#13#10 +
                 '    ?',
                 '',MB_YesNo or MB_IconQuestion) = ID_No then Exit;

    M_Reset.Enabled := FALSE;

    M_Port.Enabled := FALSE;

    CurPeriod := PeriodSave;
    ReadTemp.Create;
    BTN_Start_Stop.Caption := '&';
    M_Start_Stop.Caption   := '&';

    if NameS = __DS18B20 then
     if ReadSP(TH,TL,CnfReg) then
      if (CnfReg and $60) <> $60 then
       WriteSP(TH,TL,CnfReg or $60);

    Start := 1;
   end
  else
   begin
    M_Port.Enabled := TRUE;

    BTN_Start_Stop.Caption := '&';
    M_Start_Stop.Caption   := '&';
    sndPlaySound(nil,SND_NODEFAULT);
    Timer.Enabled := FALSE;

    Start := 0;
    Screen.Cursor := crHourGlass;

    while Start <> 3 do
     Application.ProcessMessages;

    Screen.Cursor := crDefault;

    Start := 0;

    M_Reset.Enabled := TRUE;

    UpdateGR;
   end;
 end;

//------------------------------

procedure TMain.SelectPort(Sender: TObject);
 begin
  InitCOM := 0;

  if Sender = M_COM1 then InitCOM := 1;
  if Sender = M_COM2 then InitCOM := 2;
  if Sender = M_COM3 then InitCOM := 3;
  if Sender = M_COM4 then InitCOM := 4;

  if UsedCOM <> InitCOM then
   FormActivate(Sender);
 end;

//------------------------------

procedure TMain.EditUpdateL(Edit : TEdit; T : PExtended);
 var
  s  : string;
  fs : TFormatSettings;
  p  : Extended;

 begin
  s := Edit.Text;

  if Length(s) > 0 then
   begin
    if s [Length(s)] = '.' then s := s + '0';
    if s [1] = '.' then s := '0' + s;
   end;

  GetLocaleFormatSettings(0,fs);
  fs.DecimalSeparator := '.';

  p := StrToFloatDef(s,1000,fs);

  if (p < -55) or (p > 125)  then
   begin
    Edit.Text := ExtendedToStr(T^);
    Exit;
   end;

  if Edit = EditLoL then
   if (HiL - p) < 1 then
    begin
     Edit.Text := ExtendedToStr(LoL);
     Exit;
    end;

  if Edit = EditHiL then
   if (p - LoL) < 1 then
    begin
     Edit.Text := ExtendedToStr(HiL);
     Exit;
    end;

  T^ := Round(p * 10) / 10;
  Edit.Text := ExtendedToStr(T^);
 end;

//------------------------------

procedure TMain.SpinUpdateL(Edit : TEdit; T : PExtended; But : TUDBtnType);
 begin
  EditUpdateL(Edit,T);

  if (But = btNext) and (T^ < 125) then T^ := T^ + 1;
  if (But = btPrev) and (T^ > -55) then T^ := T^ - 1;

  if Edit = EditLoL then
   if (HiL - T^) < 1 then
    begin
     T^ := T^ - 1;
     Exit;
    end;

  if Edit = EditHiL then
   if (T^ - LoL) < 1 then
    begin
     T^ := T^ + 1;
     Exit;
    end;

  Edit.Text := ExtendedToStr(T^);
 end;

//------------------------------

procedure TMain.SpinLClick(Sender: TObject; Button: TUDBtnType);
 var
  p : PExtended;
  t : TEdit;

 begin
  if Sender = SpinHiL then
   begin
    p := @HiL;
    t := EditHiL;
   end
  else
   begin
    p := @LoL;
    t := EditLoL;
   end;

  SpinUpdateL(t,p,Button);
 end;

//------------------------------

procedure TMain.EditLExit(Sender: TObject);
 var
  p : PExtended;

 begin
  if Sender = EditHiL  then p := @HiL else p := @LoL;
  EditUpdateL(Sender as TEdit,p);
 end;

//------------------------------

procedure TMain.EditLKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
 var
  b : TUDBtnType;
  p : PExtended;

 begin
  if (Shift = []) and (Key in [VK_Up,VK_Down]) then
   begin
    if Key = VK_Up then b := btNext else b := btPrev;

    if Sender = EditLoL then p := @LoL else p := @HiL;

    SpinUpdateL(Sender as TEdit,p,b);

    Key := 0;
   end;
 end;

//------------------------------

procedure TMain.EditLKeyPress(Sender: TObject; var Key: Char);
 var
  p : PExtended;

 begin
  if not (Key in ['0'..'9','.','-',#1..#31]) then Key := #0;

  if Key = #13 then
   begin
    if Sender = EditHiL  then p := @HiL else p := @LoL;
    EditUpdateL(Sender as TEdit,p);
    (Sender as TEdit).SelectAll;
    Key := #0;
   end;
 end;

//------------------------------

procedure TMain.TimerTimer(Sender: TObject);
 const
  N : Boolean = FALSE;

 begin
  N := not N;

  if N then Temp.Color := WarningColor
   else Temp.Color := NormalColor;
 end;

//------------------------------

procedure TMain.M_ASClick(Sender: TObject);
 begin
  SignalUse := not SignalUse;
  M_AS.Checked := SignalUse;
 end;

//------------------------------

procedure TMain.ControlTClick(Sender: TObject);
 begin
  EditLoL.Enabled := ControlT.Checked;
  EditHiL.Enabled := ControlT.Checked;
  SpinLoL.Enabled := ControlT.Checked;
  SpinHiL.Enabled := ControlT.Checked;
 end;

//------------------------------

procedure TMain.AutoScaleClick(Sender: TObject);
 begin
  EditLoT.Enabled := not AutoScale.Checked;
  EditHiT.Enabled := not AutoScale.Checked;
  SpinLoT.Enabled := not AutoScale.Checked;
  SpinHiT.Enabled := not AutoScale.Checked;
 end;

//------------------------------

procedure TMain.N1Click(Sender: TObject);
 begin
  Params := TParams.Create(Application);
  Params.ShowModal;
  Params.Free;

  LoD.Font.Color  := LPTColor;
  HiD.Font.Color  := HPTColor;
  MinT.Font.Color := LPTColor;
  MaxT.Font.Color := HPTColor;
 end;

//------------------------------

procedure TMain.FormActivate(Sender: TObject);
 begin
  InitSensor := TInitSensor.Create(Application);
  InitSensor.ShowModal;
  InitSensor.Free;

  if AutoRun then BTN_Start_StopClick(Sender);
 end;

//------------------------------

procedure TMain.M_PZDClick(Sender: TObject);
 begin
  PZD := TPZD.Create(Application);
  PZD.ShowModal;
  PZD.Free;
 end;

//------------------------------

procedure TMain.N4Click(Sender: TObject);
 begin
  About := TAbout.Create(Application);
  About.ShowModal;
  About.Free;
 end;

//------------------------------

procedure TMain.N3Click(Sender: TObject);
 begin
  Application.HelpFile := ExtractFilePath(ParamStr(0)) + 'HELP\help.hlp';
  Application.HelpCommand(HELP_FINDER,0);
 end;

//------------------------------

procedure TMain.M_ResetClick(Sender: TObject);
 var
  i : Byte;

 begin
  for i := 0 to 139 do
   Samples [i,1] := 1000;

  NS    := 0;
  CS    := 0;
  T_MAX := 125;
  T_MIN := -55;

  UpdateGR;
 end;

procedure TMain.M_AutoRunClick(Sender: TObject);
 begin
  AutoRun := not AutoRun;
  M_AutoRun.Checked := AutoRun;
 end;

end.
