unit InitSensorForm;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms, ComCtrls;

type
  TInitSensor = class(TForm)
    FindSensor: TLabel;
    Sensor: TLabel;
    SN: TLabel;
    Timer: TTimer;
    procedure FormActivate(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  end;

var
 InitSensor: TInitSensor;

implementation

uses MainForm, DS1820;

{$R *.DFM}

procedure TInitSensor.FormActivate(Sender: TObject);
 begin
  Timer.Enabled := TRUE;
 end;

procedure TInitSensor.TimerTimer(Sender: TObject);
 var
  b   : array [0..7] of Byte;
  f   : Boolean;
  i,n : Byte;

 begin
  f := FALSE;

  Timer.Enabled := FALSE;

  if Open_COM(InitCOM) then
   for n := 1 to 3 do
    begin
     if ResetOW then
      begin
       WriteOW($33);

       CRC := 0;

       for i := 0 to 7 do
        begin
         b [i] := ReadOW;
         UpdateCRC(b [i]);
        end;

       if CRC = 0 then
        begin
         if ResetOW then
          begin
           WriteOW($CC);
           WriteOW($BE);

           ReadOW;
           ReadOW;

           COD3 := ReadOW;
           COD4 := ReadOW;
          end;

         f := TRUE;

         if b [0] = $10 then
          begin
           if b [6] * 256 + b [5] < 8 then
            begin
             Sensor.Caption := ': DS1820';
             NameS := __DS1820;
            end
           else
            begin
             Sensor.Caption := ': DS18S20';
             NameS := __DS18S20;
            end;
          end
         else
          if b [0] = $28 then
           begin
            Sensor.Caption := ': DS18B20';
            NameS := __DS18B20;
           end
          else
           begin
            Sensor.Caption := '  !';
            NameS := __UnknownDevice;
           end;

         SN.Caption := ' : ';

         for i := 6 downto 1 do
          SN.Caption := SN.Caption + IntToHex(b [i],2);

         SN.Caption := SN.Caption + 'h';

         COD1 := Make32(b [0],b [6],b [5],b [4]);
         COD2 := Make32(b [3],b [2],b [1],b [7]);
        end;
      end;

     if f then Break else Sleep(500);
    end;

  if not f then
   with Sensor do
    begin
     Font.Color := clBlue;
     Font.Style := [fsBold];
     Caption    := '  !';
     NameS      := __UnknownDevice;
    end;

  Sensor.Update;

  Sleep(1500);
  
  SensorPresent := f;

  Close;
 end;

procedure TInitSensor.FormCreate(Sender: TObject);
 var
  Style : Integer;

 begin
  Style := GetWindowLong(Handle,GWL_STYLE);
  SetWindowLong(Handle,GWL_STYLE,Style and not WS_SYSMENU);
  
  FindSensor.Caption := Format('    COM%d...',[InitCOM]);
  Sensor.Caption := '';
  SN.Caption := '';
  COD1 := 0;
  COD2 := 0;
 end;

procedure TInitSensor.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
 begin
  if (Key = VK_F4) and (ssAlt in Shift) then Key := 0;
 end;

end.
