unit PZDForm;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls, Dialogs, Spin, ComCtrls;

type
  TPZD = class(TForm)
    BTN_OK: TButton;
    BTN_Cancel: TButton;
    SaveDlg: TSaveDialog;
    GroupBox1: TGroupBox;
    SavePeriod: TEdit;
    UpDownSavePeriod: TUpDown;
    NoSaveData: TCheckBox;
    FileData: TRadioGroup;
    GroupBox2: TGroupBox;
    FilePath: TEdit;
    BTN_SelectFile: TButton;
    procedure BTN_CancelClick(Sender: TObject);
    procedure SavePeriodKeyPress(Sender: TObject; var Key: Char);
    procedure SavePeriodExit(Sender: TObject);
    procedure BTN_OKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure NoSaveDataClick(Sender: TObject);
    procedure BTN_SelectFileClick(Sender: TObject);
    procedure FileDataClick(Sender: TObject);
  end;

var
 PZD: TPZD;

implementation

uses MainForm;

{$R *.dfm}

procedure TPZD.BTN_CancelClick(Sender: TObject);
 begin
  Close;
 end;

procedure TPZD.SavePeriodKeyPress(Sender: TObject; var Key: Char);
 begin
  if not (Key in [#0..#31,'0'..'9']) then Key := #0;
 end;

procedure TPZD.SavePeriodExit(Sender: TObject);
 var
  n : Integer;
  m : Byte;

 begin
  n  := StrToIntDef(SavePeriod.Text,0);

  if not WinNT then n := (n div 2) * 2; 

  m := 2 - Ord(WinNT);

  if n < m then SavePeriod.Text := IntToStr(m)
   else
    if n > 60 then SavePeriod.Text := '60'
     else
      SavePeriod.Text := IntToStr(n);
 end;

procedure TPZD.BTN_OKClick(Sender: TObject);
 begin
  PeriodSave := StrToIntDef(SavePeriod.Text,0);
  CurPeriod  := 0;

  if (FileData.ItemIndex <> Ord(FileType)) or (FilePath.Text <> FileSave) then
   begin
    FileType := FileData.ItemIndex = 1;

    if Start > 0 then
     begin
      NoSave := 1;
      while NoSave <> 2 do
       Application.ProcessMessages;
     end; 

    FileSave := FilePath.Text;
    
    CloseFile(FOut);
    CreateFileOutput(TRUE);
    NoSave := 0;
   end;
 end;

procedure TPZD.FormCreate(Sender: TObject);
 begin
  with UpDownSavePeriod do
   begin
    Position  := PeriodSave;
    Increment := 2 - Ord(WinNT);
    Min       := Increment;
   end;

  NoSaveData.Checked := not DataSave;
  FileData.ItemIndex := Ord(FileType);
  FilePath.Text := FileSave;
  FileDataClick(Sender);
 end;

procedure TPZD.NoSaveDataClick(Sender: TObject);
 begin
  if NoSaveData.Checked then
   begin
    SavePeriod.Enabled := FALSE;
    UpDownsavePeriod.Enabled := FALSE;
    FileData.Enabled := FALSE;
    FilePath.Enabled := FALSE;
    BTN_SelectFile.Enabled := FALSE;

    if DataSave then
     begin
      if Start > 0 then
       begin
        NoSave := 1;
        Screen.Cursor := crHourGlass;
        
        while NoSave <> 2 do
         Application.ProcessMessages;
        
        Screen.Cursor := crDefault;
       end;

      CloseFile(FOut);
     end;
   end
  else
   begin
    SavePeriod.Enabled := TRUE;
    UpDownsavePeriod.Enabled := TRUE;
    FileData.Enabled := TRUE;
    FilePath.Enabled := TRUE;
    BTN_SelectFile.Enabled := TRUE;

    CreateFileOutput(TRUE);
   end;

  DataSave := not NoSaveData.Checked;
 end;

procedure TPZD.BTN_SelectFileClick(Sender: TObject);
 begin
  if SaveDlg.Execute then
   begin
    FilePath.Text := SaveDlg.FileName;
   end;
 end;

procedure TPZD.FileDataClick(Sender: TObject);
 begin
  if FileData.ItemIndex = 1 then
   begin
    FilePath.ReadOnly := FALSE;
    FilePath.Color := clWindow;
    BTN_SelectFile.Enabled := TRUE;
   end
  else
   begin
    FilePath.ReadOnly := TRUE;
    FilePath.Color := clBtnFace;
    BTN_SelectFile.Enabled := FALSE;
   end;
 end;

end.
