unit DS1820;

interface

uses Classes, Forms;

type
 ReadTemp = class(TThread)
  protected
   procedure Execute; override;
  public
   constructor Create;
 end;

var
 CRC : Byte = 0;

function  Rand (l : Cardinal) : Cardinal;
function  Make32 (a,b,c,d : Byte) : Cardinal;
procedure UpdateCRC(b : Byte);
function  ResetOW : Boolean;
procedure WriteOW(x : Byte);
function  ReadOW : Byte;
function  ReadMem (var Mem : array of Byte) : Boolean;
function  ReadTempData (var TL, TH, CR, CP : Byte) : Boolean;
function  ReadSP (var TH,TL,CnfReg : Byte) : Boolean;
procedure WriteSP (TH,TL,CnfReg : Byte);

implementation

uses Windows, TxRx, MainForm, SysUtils, DateUtils;

//------------------------------

function Rand (l : Cardinal) : Cardinal;
 begin
  Rand := l * 1103515245 + 12345;
 end;

//------------------------------

function Make32 (a,b,c,d : Byte) : Cardinal;
 begin
  Make32 := (Cardinal(a) shl 24) or (Cardinal(b) shl 16) or
            (Cardinal(c) shl 8)  or d;
 end;

//------------------------------

procedure UpdateCRC(b : Byte);
 var
  i : Byte;

 begin
  for i := 1 to 8 do
   begin
    if ((b xor CRC) and 1) > 0 then CRC := ((CRC xor $18) shr 1) or $80
     else CRC := CRC shr 1;

    b := b shr 1;
   end;
 end;

//------------------------------

function ResetOW : Boolean;
 var
  b   : Byte;
  d,t : Cardinal;

 begin
  Result := FALSE;

  SetModCOM(9600,8,NOPARITY,ONESTOPBIT,TRUE,FALSE);
  PurgeCOM;

  TxByteCOM($F0);

  t := GetTickCount + 50;

  repeat
   RxDataCOM(b,1,d)
  until (d = 1) or (t < GetTickCount);

  SetModCOM(115200,8,NOPARITY,ONESTOPBIT,TRUE,FALSE);

  if d = 1 then Result := b <> $F0;
 end;

//------------------------------

procedure WriteOW(x : Byte);
 var
  n,b : Byte;
  d,t : Cardinal;

 begin
  PurgeCOM;

  t := GetTickCount + 50;

  for n := 1 to 8 do
   begin
    if Odd(x) then TxByteCOM($FF) else TxByteCOM($00);

    x := x shr 1;

    repeat
     RxDataCOM(b,1,d)
    until (d = 1) or (t < GetTickCount);

    if d <> 1 then Exit;
   end;
 end;

//------------------------------

function ReadOW : Byte;
 var
  n,b,x : Byte;
  d,t   : Cardinal;

 begin
  Result := $FF;

  PurgeCOM;

  t := GetTickCount + 50;

  x := 0;

  for n := 1 to 8 do
   begin
    TxByteCOM($FF);

    x := x shr 1;

    repeat
     RxDataCOM(b,1,d)
    until (d = 1) or (t < GetTickCount);

    if d <> 1 then Exit;

    if Odd(b) then x := x or $80;
   end;

  Result := x;
 end;

//------------------------------

function ReadMem (var Mem : array of Byte) : Boolean;
 var
  i : Byte;

 begin
  Result := FALSE;
  
  if ResetOW then
   begin
    WriteOW($CC);
    WriteOW($BE);

    CRC := 0;

    for i := 0 to 7 do
     begin
      Mem [i] := ReadOW;
      UpdateCRC(Mem [i]);
     end;

    Result := CRC = ReadOW;
   end;
 end;

//------------------------------

function ReadTempData (var TL, TH, CR, CP : Byte) : Boolean;
 var
  b : array [0..7] of Byte;

 begin
  Result := ReadMem(b);

  TL := b [0];
  TH := b [1];
  CR := b [6];
  CP := b [7];
 end;

//------------------------------

function ReadSP (var TH,TL,CnfReg : Byte) : Boolean;
 var
  b : array [0..7] of Byte;

 begin
  Result := ReadMem(b);

  TH     := b [2];
  TL     := b [3];
  CnfReg := b [4];
 end;

//------------------------------

procedure WriteSP (TH,TL,CnfReg : Byte);
 var
  _TH,_TL,_CnfReg : Byte;

 begin
  if NameS <> __DS18B20 then CnfReg := $FF;

  if ResetOW then
   begin
    WriteOW($CC);
    WriteOW($4E);
    WriteOW(TH);
    WriteOW(TL);
    WriteOW(CnfReg);
   end;

  if ReadSP(_TH,_TL,_CnfReg) then
   if (_TH = TH) and (_TL = TL) and (_CnfReg = CnfReg) then
    if ResetOW then
     begin
      WriteOW($CC);
      WriteOW($48);
      Sleep(10);
     end;
 end;

//------------------------------

constructor ReadTemp.Create;
 begin
  FreeOnTerminate := TRUE;
  inherited Create(FALSE);
 end;

//------------------------------

procedure ReadTemp.Execute;
 var
  TL,TH : Byte;
  CR,Cp : Byte;
  i     : Byte;
  T     : Extended;
  p     : Integer;
  nerr  : Byte;

 begin
  Synchronize(Main.UpdateGR);

  Start := 2;

  nerr := 0;

  repeat
   p := GetTickCount;

   T := 1000;

   if SensorPresent then
    begin
     if ResetOW then
      begin
       WriteOW($CC);
       WriteOW($44);

       Sleep(750);

       if ReadTempData(TL,TH,CR,CP) then
        begin
         if NameS in [__DS1820,__DS18S20] then // DS1820, DS18S20
          begin
           T := TL / 2;
           if TH > 0 then T := -T;
           T := T - 0.25 + (CP - CR) / CP;
           T := Round(T * 10) / 10;
          end
         else // DS18B20
          if TH <= 7 then
           T := ((TH shl 8) or TL) / 16
          else
           T := -(65536 - ((TH shl 8) or TL)) / 16;
        end;
      end;
    end
   else
    begin
     T := 4 * Pi * NS / 140;
     T := 10 * Sin(T);
    end;

   if T < 1000 then
    begin
     for i := 139 downto 1 do
      Samples [i] := Samples [i - 1];

     Samples [0,1] := T;
     Samples [0,2] := LoL;
     Samples [0,3] := HiL;

     T_Error := FALSE;
    end
   else
    if nerr < 2 then
     begin
      Inc(nerr);
      Continue;
     end
    else
      T_Error := TRUE;

   if NoSave = 1 then NoSave := 2;

   if (CurPeriod >= PeriodSave) and DataSave and (NoSave = 0) then
    begin
     CurPeriod := 0;

     if Date <> DateFileOut then
      begin
       CloseFile(FOut);
       CreateFileOutput(FALSE);
      end;

     WriteLN(FOut,TimeToStr(Time),',',ExtendedToStr(T),',',
             ExtendedToStr(Samples [0,2]),',',ExtendedToStr(Samples [0,3]));
    end;

   Inc(CurPeriod);

   if T < 1000 then
    begin
     Inc(NS);

     if NS >= 140 then NS := 0;

     if CS < 140 then Inc(CS);

     T_MAX := Samples [0,1];
     T_MIN := Samples [0,1];

     for i := 1 to CS - 1 do
      begin
       if Samples [i,1] > T_MAX then T_MAX := Samples [i,1];
       if Samples [i,1] < T_MIN then T_MIN := Samples [i,1];
      end;
    end;

   Synchronize(Main.UpdateGR);

   if T_Error then
    Application.Title := ' !'
   else
    Application.Title := 't = ' + ExtendedToStr(T) + ' C';

   p := 1000 * (2 - Ord(WinNT)) - (GetTickCount - p);

   if p > 0 then Sleep(p);
  until Terminated or (Start = 0);

  Start := 3;
 end;

end.
