        LIST
; P16F1937.INC  Standard Header File, Version 1.0    Microchip Technology, Inc.
        NOLIST

; This header file defines configurations, registers, and other useful bits of
; information for the PIC16F1937 microcontroller.
; These names are taken to match the data sheets as closely as possible.  

; Note that the processor must be selected before this file is 
; included.  The processor may be selected the following ways:

;       1. Command line switch:
;               C:\ MPASM MYFILE.ASM /PIC16F1937
;       2. LIST directive in the source file
;               LIST   P=PIC16F1937
;       3. Processor Type entry in the MPASM full-screen interface

;==========================================================================
;
;       Revision History
;
;==========================================================================

;Rev:   Date:    Reason:
;1.00   02/22/08 Initial Release

;==========================================================================
;
;       Verify Processor
;
;==========================================================================

        IFNDEF __16F1937
           MESSG "Processor-header file mismatch.  Verify selected processor."
        ENDIF

;==========================================================================
;
;       Register Definitions
;
;==========================================================================

W                            EQU     H'0000'
F                            EQU     H'0001'

;----- Register Files------------------------------------------------------

;-----Bank0---------------------------------
INDF0                        EQU     H'0000'
INDF1                        EQU     H'0001'
PCL                          EQU     H'0002'
STATUS                       EQU     H'0003'
FSR0L                        EQU     H'0004'
FSR0H                        EQU     H'0005'
FSR1L                        EQU     H'0006'
FSR1H                        EQU     H'0007'
BSR                          EQU     H'0008'
WREG                         EQU     H'0009'
PCLATH                       EQU     H'000A'
INTCON                       EQU     H'000B'
PORTA                        EQU     H'000C'
PORTB                        EQU     H'000D'
PORTC                        EQU     H'000E'
PORTD                        EQU     H'000F'
PORTE                        EQU     H'0010'
PIR1                         EQU     H'0011'
PIR2                         EQU     H'0012'
PIR3                         EQU     H'0013'
TMR0                         EQU     H'0015'
TMR1L                        EQU     H'0016'
TMR1H                        EQU     H'0017'
T1CON                        EQU     H'0018'
T1GCON                       EQU     H'0019'
TMR2                         EQU     H'001A'
PR2                          EQU     H'001B'
T2CON                        EQU     H'001C'

;-----Bank1---------------------------------
TRISA                        EQU     H'008C'
TRISB                        EQU     H'008D'
TRISC                        EQU     H'008E'
TRISD                        EQU     H'008F'
TRISE                        EQU     H'0090'
PIE1                         EQU     H'0091'
PIE2                         EQU     H'0092'
PIE3                         EQU     H'0093'
OPTION_REG                   EQU     H'0095'
PCON                         EQU     H'0096'
WDTCON                       EQU     H'0097'
OSCTUNE                      EQU     H'0098'
OSCCON0                      EQU     H'0099'
OSCCON1                      EQU     H'009A'
ADRESL                       EQU     H'009B'
ADRESH                       EQU     H'009C'
ADCON0                       EQU     H'009D'
ADCON1                       EQU     H'009E'

;-----Bank2---------------------------------
LATA                         EQU     H'010C'
LATB                         EQU     H'010D'
LATC                         EQU     H'010E'
LATD                         EQU     H'010F'
LATE                         EQU     H'0110'
CM1CON0                      EQU     H'0111'
CM1CON1                      EQU     H'0112'
CM2CON0                      EQU     H'0113'
CM2CON1                      EQU     H'0114'
CMOUT                        EQU     H'0115'
VREFCON0                     EQU     H'0116'
VREFCON1                     EQU     H'0117'
VREFCON2                     EQU     H'0118'
SRCON0                       EQU     H'0119'
SRCON1                       EQU     H'011A'
APFCON                       EQU     H'011C'
CPSCON0                      EQU     H'011E'
CPSCON1                      EQU     H'011F'

;-----Bank3---------------------------------
ANSELA                       EQU     H'018C'
ANSELB                       EQU     H'018D'
ANSELD                       EQU     H'018F'
ANSELE                       EQU     H'0190'
EEADRL                       EQU     H'0191'
EEADRH                       EQU     H'0192'
EEDATL                       EQU     H'0193'
EEDATH                       EQU     H'0194'
EECON1                       EQU     H'0195'
EECON2                       EQU     H'0196'
RCREG                        EQU     H'0199'
TXREG                        EQU     H'019A'
SPBRGL                       EQU     H'019B'
SPBRGH                       EQU     H'019C'
RCSTA                        EQU     H'019D'
TXSTA                        EQU     H'019E'
BAUDCTL                      EQU     H'019F'

;-----Bank4---------------------------------
WPUB                         EQU     H'020D'
SSPBUF                       EQU     H'0211'
SSPADD                       EQU     H'0212'
SSPMASK                      EQU     H'0213'
SSPSTAT                      EQU     H'0214'
SSPCON                       EQU     H'0215'
SSPCON2                      EQU     H'0216'
SSPCON3                      EQU     H'0217'

;-----Bank5---------------------------------
CCPR1L                       EQU     H'0291'
CCPR1H                       EQU     H'0292'
CCP1CON                      EQU     H'0293'
PWM1CON                      EQU     H'0294'
CCP1AS                       EQU     H'0295'
PSTR1CON                     EQU     H'0296'
CCPR2L                       EQU     H'0298'
CCPR2H                       EQU     H'0299'
CCP2CON                      EQU     H'029A'
PWM2CON                      EQU     H'029B'
CCP2AS                       EQU     H'029C'
PSTR2CON                     EQU     H'029D'
CCPTMRS                      EQU     H'029E'
CCPTMRS2                     EQU     H'029F'

;-----Bank6---------------------------------
CCPR3L                       EQU     H'0311'
CCPR3H                       EQU     H'0312'
CCP3CON                      EQU     H'0313'
PWM3CON                      EQU     H'0314'
CCP3AS                       EQU     H'0315'
PSTR3CON                     EQU     H'0316'
CCPR4L                       EQU     H'0318'
CCPR4H                       EQU     H'0319'
CCP4CON                      EQU     H'031A'
CCPR5L                       EQU     H'031C'
CCPR5H                       EQU     H'031D'
CCP5CON                      EQU     H'031E'

;-----Bank7---------------------------------
IOCBP                        EQU     H'0394'
IOCBN                        EQU     H'0395'
IOCBF                        EQU     H'0396'

;-----Bank8---------------------------------
TMR4                         EQU     H'0415'
PR4                          EQU     H'0416'
T4CON                        EQU     H'0417'
TMR6                         EQU     H'041C'
PR6                          EQU     H'041D'
T6CON                        EQU     H'041E'

;-----Bank15--------------------------------
LCDCON                       EQU     H'0791'
LCDPS                        EQU     H'0792'
LCDREF                       EQU     H'0793'
LCDSE0                       EQU     H'0795'
LCDSE1                       EQU     H'0796'
LCDSE2                       EQU     H'0797'
LCDDATA0                     EQU     H'07A0'
LCDDATA1                     EQU     H'07A1'
LCDDATA2                     EQU     H'07A2'
LCDDATA3                     EQU     H'07A3'
LCDDATA4                     EQU     H'07A4'
LCDDATA5                     EQU     H'07A5'
LCDDATA6                     EQU     H'07A6'
LCDDATA7                     EQU     H'07A7'
LCDDATA8                     EQU     H'07A8'
LCDDATA9                     EQU     H'07A9'
LCDDATA10                    EQU     H'07AA'
LCDDATA11                    EQU     H'07AB'


;----- STATUS Bits --------------------------------------------------------

NOT_TO                       EQU     H'0004'
NOT_PD                       EQU     H'0003'
Z                            EQU     H'0002'
DC                           EQU     H'0001'
C                            EQU     H'0000'

;----- BSR Bits -----------------------------------------------------------

BSR3                         EQU     H'0003'
BSR2                         EQU     H'0002'
BSR1                         EQU     H'0001'
BSR0                         EQU     H'0000'

;----- INTCON Bits --------------------------------------------------------

GIE                          EQU     H'0007'
PEIE                         EQU     H'0006'
TMR0IE                       EQU     H'0005'
INTE                         EQU     H'0004'
IOCIE                        EQU     H'0003'
TMR0IF                       EQU     H'0002'
INTF                         EQU     H'0001'
IOCIF                        EQU     H'0000'

;------ PORTE Bits ----------------------------------------------------------

RE3                          EQU     H'0003'

;----- PIR1 Bits ----------------------------------------------------------

TMR1GIF                      EQU     H'0007'
ADIF                         EQU     H'0006'
RCIF                         EQU     H'0005'
TXIF                         EQU     H'0004'
SSPIF                        EQU     H'0003'
CCP1IF                       EQU     H'0002'
TMR2IF                       EQU     H'0001'
TMR1IF                       EQU     H'0000'

;----- PIR2 Bits ----------------------------------------------------------

OSFIF                        EQU     H'0007'
C2IF                         EQU     H'0006'
C1IF                         EQU     H'0005'
EEIF                         EQU     H'0004'
BCLIF                        EQU     H'0003'
LCDIF                        EQU     H'0002'
CCP2IF                       EQU     H'0000'

;----- PIR3 Bits ----------------------------------------------------------

CCP5IF                       EQU     H'0006'
CCP4IF                       EQU     H'0005'
CCP3IF                       EQU     H'0004'
TMR6IF                       EQU     H'0003'
TMR4IF                       EQU     H'0001'

;----- T1CON Bits ---------------------------------------------------------

TMR1CS1                      EQU     H'0007'
TMR1CS0                      EQU     H'0006'
T1CKPS1                      EQU     H'0005'
T1CKPS0                      EQU     H'0004'
T1OSCEN                      EQU     H'0003'
NOT_T1SYNC                   EQU     H'0002' 
TMR1ON                       EQU     H'0000'

;------ T1GCON Bits ---------------------------------------------------------

TMR1GE                       EQU     H'0007'
T1GPOL                       EQU     H'0006'
T1GTM                        EQU     H'0005'
T1GSPM                       EQU     H'0004'
T1GGO                        EQU     H'0003'
T1GVAL                       EQU     H'0002'
T1GSS1                       EQU     H'0001'
T1GSS0                       EQU     H'0000'

;----- T2CON Bits ---------------------------------------------------------

TOUTPS3                      EQU     H'0006'
TOUTPS2                      EQU     H'0005'
TOUTPS1                      EQU     H'0004'
TOUTPS0                      EQU     H'0003'
TMR2ON                       EQU     H'0002'
T2CKPS1                      EQU     H'0001'
T2CKPS0                      EQU     H'0000'

;----- PIE1 Bits ----------------------------------------------------------

TMR1GIE                      EQU     H'0007'
ADIE                         EQU     H'0006'
RCIE                         EQU     H'0005'
TXIE                         EQU     H'0004'
SSPIE                        EQU     H'0003'
CCP1IE                       EQU     H'0002'
TMR2IE                       EQU     H'0001'
TMR1IE                       EQU     H'0000'

;----- PIE2 Bits ----------------------------------------------------------

OSFIE                        EQU     H'0007'
C2IE                         EQU     H'0006'
C1IE                         EQU     H'0005'
EEIE                         EQU     H'0004'
BCLIE                        EQU     H'0003'
LCDIE                        EQU     H'0002'
CCP2IE                       EQU     H'0000'

;----- PIE3 Bits ----------------------------------------------------------

CCP5IE                       EQU     H'0006'
CCP4IE                       EQU     H'0005'
CCP3IE                       EQU     H'0004'
TMR6IE                       EQU     H'0003'
TMR4IE                       EQU     H'0001'

;----- OPTION_REG Bits -----------------------------------------------------

NOT_RBPU                     EQU     H'0007'
INTEDG                       EQU     H'0006'
T0CS                         EQU     H'0005'
T0SE                         EQU     H'0004'
PSA                          EQU     H'0003'
PS2                          EQU     H'0002'
PS1                          EQU     H'0001'
PS0                          EQU     H'0000'

;----- PCON Bits ----------------------------------------------------------

STKOVF                       EQU     H'0007'
STKUNF                       EQU     H'0006'
SBOREN                       EQU     H'0004'
NOT_RMCLR                    EQU     H'0003'
NOT_RI                       EQU     H'0002'
NOT_POR                      EQU     H'0001'
NOT_BOR                      EQU     H'0000'

;----- WDTCON Bits --------------------------------------------------------

SWDTCS                       EQU     H'0006'
WDTPS4                       EQU     H'0005'
WDTPS3                       EQU     H'0004'
WDTPS2                       EQU     H'0003'
WDTPS1                       EQU     H'0002'
WDTPS0                       EQU     H'0001'
SWDTEN                       EQU     H'0000'

;----- OSCTUNE Bits -------------------------------------------------------

TUN5                         EQU     H'0005'
TUN4                         EQU     H'0004'
TUN3                         EQU     H'0003'
TUN2                         EQU     H'0002'
TUN1                         EQU     H'0001'
TUN0                         EQU     H'0000'

;----- ADCON0 Bits --------------------------------------------------------

CHS4                         EQU     H'0006'
CHS3                         EQU     H'0005'
CHS2                         EQU     H'0004'
CHS1                         EQU     H'0003'
CHS0                         EQU     H'0002'
NOT_DONE                     EQU     H'0001'
GO_DONE                      EQU     H'0001'
ADON                         EQU     H'0000'

;----- ADCON1 Bits --------------------------------------------------------

ADFM                         EQU     H'0007'
ADCS2                        EQU     H'0006'
ADCS1                        EQU     H'0005'
ADCS0                        EQU     H'0004'
ADNREF                       EQU     H'0002'
ADPREF1                      EQU     H'0001'
ADPREF0                      EQU     H'0000'

;------ LATE Bits ----------------------------------------------------------

LATE3                        EQU     H'0003'


;------ CM1CON0 Bits --------------------------------------------------------

C1ON                         EQU     H'0007'
C1OUT                        EQU     H'0006'
C1OE                         EQU     H'0005'
C1POL                        EQU     H'0004'
C1SP                         EQU     H'0002'
C1HYS                        EQU     H'0001'
C1SYNC                       EQU     H'0000'

;------ CM1CON1 Bits --------------------------------------------------------

C1INTP                       EQU     H'0007'
C1INTN                       EQU     H'0006'
C1PCH1                       EQU     H'0005'
C1PCH0                       EQU     H'0004'
C1NCH1                       EQU     H'0001'
C1NCH0                       EQU     H'0000'

;------ CM2CON0 Bits --------------------------------------------------------

C2ON                         EQU     H'0007'
C2OUT                        EQU     H'0006'
C2OE                         EQU     H'0005'
C2POL                        EQU     H'0004'
C2SP                         EQU     H'0002'
C2HYS                        EQU     H'0001'
C2SYNC                       EQU     H'0000'

;------ CM2CON1 Bits --------------------------------------------------------

C2INTP                       EQU     H'0007'
C2INTN                       EQU     H'0006'
C2PCH1                       EQU     H'0005'
C2PCH0                       EQU     H'0004'
C2NCH1                       EQU     H'0001'
C2NCH0                       EQU     H'0000'

;------ CMOUT Bits ----------------------------------------------------------

MC2OUT                       EQU     H'0001'
MC1OUT                       EQU     H'0000'

;------ SRCON0 Bits ---------------------------------------------------------

SRLEN                        EQU     H'0007'
SRCLK2                       EQU     H'0006'
SRCLK1                       EQU     H'0005'
SRCLK0                       EQU     H'0004'
SRQEN                        EQU     H'0003'
SRNQEN                       EQU     H'0002'
SRPS                         EQU     H'0001'
SRPR                         EQU     H'0000'

;------ SRCON1 Bits ---------------------------------------------------------

SRSPE                        EQU     H'0007'
SRSCKE                       EQU     H'0006'
SRSC2E                       EQU     H'0005'
SRSC1E                       EQU     H'0004'
SRRPE                        EQU     H'0003'
SRRCKE                       EQU     H'0002'
SRRC2E                       EQU     H'0001'
SRRC1E                       EQU     H'0000'

;------ APFCON Bits ---------------------------------------------------------

T1GSEL                       EQU     H'0005'
P2BSEL                       EQU     H'0004'
SRNQSEL                      EQU     H'0003'
C2OUTSEL                     EQU     H'0002'
SSSEL                        EQU     H'0001'
CCP2SEL                      EQU     H'0000'

;------ CPSCON0 Bits --------------------------------------------------------

CPSON                        EQU     H'0007'
CPSRNG1                      EQU     H'0003'
CPSRNG0                      EQU     H'0002'
CPSOUT                       EQU     H'0001'
T0XCS                        EQU     H'0000'

;------ CPSCON1 Bits --------------------------------------------------------

CPSCH3                       EQU     H'0003'
CPSCH2                       EQU     H'0002'
CPSCH1                       EQU     H'0001'
CPSCH0                       EQU     H'0000'

;----- ANSELA Bits ---------------------------------------------------------

ANSA5                        EQU     H'0005'
ANSA4                        EQU     H'0004'
ANSA3                        EQU     H'0003'
ANSA2                        EQU     H'0002'
ANSA1                        EQU     H'0001'
ANSA0                        EQU     H'0000'

;----- ANSELB Bits ---------------------------------------------------------

ANSB5                        EQU     H'0005'
ANSB4                        EQU     H'0004'
ANSB3                        EQU     H'0003'
ANSB2                        EQU     H'0002'
ANSB1                        EQU     H'0001'
ANSB0                        EQU     H'0000'

;----- ANSELD Bits ---------------------------------------------------------

ANSD7                        EQU     H'0007'
ANSD6                        EQU     H'0006'
ANSD5                        EQU     H'0005'
ANSD4                        EQU     H'0004'
ANSD3                        EQU     H'0003'
ANSD2                        EQU     H'0002'
ANSD1                        EQU     H'0001'
ANSD0                        EQU     H'0000'

;----- ANSELE Bits ---------------------------------------------------------

ANSE2                        EQU     H'0002'
ANSE1                        EQU     H'0001'
ANSE0                        EQU     H'0000'

;----- EEADRH Bits --------------------------------------------------------

EEADRH4                      EQU     H'0004'
EEADRH3                      EQU     H'0003'
EEADRH2                      EQU     H'0002'
EEADRH1                      EQU     H'0001'
EEADRH0                      EQU     H'0000'

;----- EEADRL Bits --------------------------------------------------------

EEADRL7                      EQU     H'0007'
EEADRL6                      EQU     H'0006'
EEADRL5                      EQU     H'0005'
EEADRL4                      EQU     H'0004'
EEADRL3                      EQU     H'0003'
EEADRL2                      EQU     H'0002'
EEADRL1                      EQU     H'0001'
EEADRL0                      EQU     H'0000'

;----- EECON1 Bits --------------------------------------------------------

EEPGD                        EQU     H'0007'
FREE                         EQU     H'0004'
WRERR                        EQU     H'0003'
WREN                         EQU     H'0002'
WR                           EQU     H'0001'
RD                           EQU     H'0000'

;------ SPBRGL Bits ---------------------------------------------------------

BRG7                         EQU     H'0007'
BRG6                         EQU     H'0006'
BRG5                         EQU     H'0005'
BRG4                         EQU     H'0004'
BRG3                         EQU     H'0003'
BRG2                         EQU     H'0002'
BRG1                         EQU     H'0001'
BRG0                         EQU     H'0000'

;------ SPBRGH Bits ---------------------------------------------------------

BRG15                        EQU     H'0007'
BRG14                        EQU     H'0006'
BRG13                        EQU     H'0005'
BRG12                        EQU     H'0004'
BRG11                        EQU     H'0003'
BRG10                        EQU     H'0002'
BRG9                         EQU     H'0001'
BRG8                         EQU     H'0000'

;----- RCSTA Bits ---------------------------------------------------------

SPEN                         EQU     H'0007'
RX9                          EQU     H'0006'
SREN                         EQU     H'0005'
CREN                         EQU     H'0004'
ADDEN                        EQU     H'0003'
FERR                         EQU     H'0002'
OERR                         EQU     H'0001'
RX9D                         EQU     H'0000'

;----- TXSTA Bits ---------------------------------------------------------

CSRC                         EQU     H'0007'
TX9                          EQU     H'0006'
TXEN                         EQU     H'0005' 
SYNC                         EQU     H'0004'
SENDB                        EQU     H'0003'
BRGH                         EQU     H'0002'
TRMT                         EQU     H'0001'
TX9D                         EQU     H'0000'

;------ BAUDCTL Bits --------------------------------------------------------

ABDOVF                       EQU     H'0007'
RCIDL                        EQU     H'0006'
SCKP                         EQU     H'0004'
BRG16                        EQU     H'0003'
WUE                          EQU     H'0001'
ABDEN                        EQU     H'0000'

;----- WPUB Bits -------------------------------------------------------

WPUB7                        EQU     H'0007'
WPUB6                        EQU     H'0006'
WPUB5                        EQU     H'0005'
WPUB4                        EQU     H'0004'
WPUB3                        EQU     H'0003'
WPUB2                        EQU     H'0002'
WPUB1                        EQU     H'0001'
WPUB0                        EQU     H'0000'

;----- SSPSTAT Bits -------------------------------------------------------

SMP                          EQU     H'0007'
CKE                          EQU     H'0006'
NOT_A                        EQU     H'0005'
D_A                          EQU     H'0005'
P                            EQU     H'0004'
S                            EQU     H'0003'
NOT_W                        EQU     H'0002'
R_W                          EQU     H'0002'
UA                           EQU     H'0001'
BF                           EQU     H'0000'

;----- SSPCON Bits --------------------------------------------------------

WCOL                         EQU     H'0007'
SSPOV                        EQU     H'0006'
SSPEN                        EQU     H'0005'
CKP                          EQU     H'0004'
SSPM3                        EQU     H'0003'
SSPM2                        EQU     H'0002'
SSPM1                        EQU     H'0001'
SSPM0                        EQU     H'0000'

;----- SSPCON2 Bits --------------------------------------------------------

GCEN                         EQU     H'0007'
ACKSTAT                      EQU     H'0006'
ACKDT                        EQU     H'0005'
ACKEN                        EQU     H'0004'
RCEN                         EQU     H'0003'
PEN                          EQU     H'0002'
RSEN                         EQU     H'0001'
SEN                          EQU     H'0000'

;----- CCP1CON Bits -------------------------------------------------------

P1M1                         EQU     H'0007'
P1M0                         EQU     H'0006'
DC1B1                        EQU     H'0005'
DC1B0                        EQU     H'0004'
CCP1M3                       EQU     H'0003'
CCP1M2                       EQU     H'0002'
CCP1M1                       EQU     H'0001'
CCP1M0                       EQU     H'0000'

;------ PWM1CON Bits --------------------------------------------------------

P1RSEN                       EQU     H'0007'
P1DC6                        EQU     H'0006'
P1DC5                        EQU     H'0005'
P1DC4                        EQU     H'0004'
P1DC3                        EQU     H'0003'
P1DC2                        EQU     H'0002'
P1DC1                        EQU     H'0001'
P1DC0                        EQU     H'0000'

;------ CCP1AS Bits ---------------------------------------------------------

CCP1ASE                      EQU     H'0007'
CCP1AS2                      EQU     H'0006'
CCP1AS1                      EQU     H'0005'
CCP1AS0                      EQU     H'0004'
PSS1AC1                      EQU     H'0003'
PSS1AC0                      EQU     H'0002'
PSS1BD1                      EQU     H'0001'
PSS1BD0                      EQU     H'0000'

;------ PSTR1CON Bits -------------------------------------------------------

STR1SYNC                     EQU     H'0004'
STR1D                        EQU     H'0003'
STR1C                        EQU     H'0002'
STR1B                        EQU     H'0001'
STR1A                        EQU     H'0000'

;----- CCP2CON Bits -------------------------------------------------------

P2M1                         EQU     H'0007'
P2M0                         EQU     H'0006'
DC2B1                        EQU     H'0005'
DC2B0                        EQU     H'0004'
CCP2M3                       EQU     H'0003'
CCP2M2                       EQU     H'0002'
CCP2M1                       EQU     H'0001'
CCP2M0                       EQU     H'0000'

;------ PWM2CON Bits --------------------------------------------------------

P2RSEN                       EQU     H'0007'
P2DC6                        EQU     H'0006'
P2DC5                        EQU     H'0005'
P2DC4                        EQU     H'0004'
P2DC3                        EQU     H'0003'
P2DC2                        EQU     H'0002'
P2DC1                        EQU     H'0001'
P2DC0                        EQU     H'0000'

;------ CCP2AS Bits ---------------------------------------------------------

CCP2ASE                      EQU     H'0007'
CCP2AS2                      EQU     H'0006'
CCP2AS1                      EQU     H'0005'
CCP2AS0                      EQU     H'0004'
PSS2AC1                      EQU     H'0003'
PSS2AC0                      EQU     H'0002'
PSS2BD1                      EQU     H'0001'
PSS2BD0                      EQU     H'0000'

;------ PSTR2CON Bits -------------------------------------------------------

STR2SYNC                     EQU     H'0004'
STR2D                        EQU     H'0003'
STR2C                        EQU     H'0002'
STR2B                        EQU     H'0001'
STR2A                        EQU     H'0000'

;------ CCPTMRS Bits --------------------------------------------------------

C4TSEL1                      EQU     H'0007'
C4TSEL0                      EQU     H'0006'
C3TSEL1                      EQU     H'0005'
C3TSEL0                      EQU     H'0004'
C2TSEL1                      EQU     H'0003'
C2TSEL0                      EQU     H'0002'
C1TSEL1                      EQU     H'0001'
C1TSEL0                      EQU     H'0000'

;------ CCPTMRS2 Bits -------------------------------------------------------

C5TSEL1                      EQU     H'0001'
C5TSEL0                      EQU     H'0000'

;------ CCP3CON Bits --------------------------------------------------------

P3M1                         EQU     H'0007'
P3M0                         EQU     H'0006'
DC3B1                        EQU     H'0005'
DC3B0                        EQU     H'0004'
CCP3M3                       EQU     H'0003'
CCP3M2                       EQU     H'0002'
CCP3M1                       EQU     H'0001'
CCP3M0                       EQU     H'0000'

;------ PWM3CON Bits --------------------------------------------------------

P3RSEN                       EQU     H'0007'
P3DC6                        EQU     H'0006'
P3DC5                        EQU     H'0005'
P3DC4                        EQU     H'0004'
PCDC3                        EQU     H'0003'
P3DC2                        EQU     H'0002'
P3DC1                        EQU     H'0001'
P3DC0                        EQU     H'0000'

;------ CCP3AS Bits ---------------------------------------------------------

CCP3ASE                      EQU     H'0007'
CCP3AS2                      EQU     H'0006'
CCP3AS1                      EQU     H'0005'
CCP3AS0                      EQU     H'0004'
PSS3AC1                      EQU     H'0003'
PSS3AC0                      EQU     H'0002'
PSS3BD1                      EQU     H'0001'
PSS3BD0                      EQU     H'0000'

;------ PSTR3CON Bits -------------------------------------------------------

STR3SYNC                     EQU     H'0004'
STR3D                        EQU     H'0003'
STR3C                        EQU     H'0002'
STR3B                        EQU     H'0001'
STR3A                        EQU     H'0000'

;------ CCP4CON Bits --------------------------------------------------------

DC4B1                        EQU     H'0005'
DC4B0                        EQU     H'0004'
CCP4M3                       EQU     H'0003'
CCP4M2                       EQU     H'0002'
CCP4M1                       EQU     H'0001'
CCP4M0                       EQU     H'0000'

;------ CCP5CON Bits --------------------------------------------------------

DC5B1                        EQU     H'0005'
DC5B0                        EQU     H'0004'
CCP5M3                       EQU     H'0003'
CCP5M2                       EQU     H'0002'
CCP5M1                       EQU     H'0001'
CCP5M0                       EQU     H'0000'

;----- IOCBP Bits -------------------------------------------------------

IOCBP7                       EQU     H'0007'
IOCBP6                       EQU     H'0006'
IOCBP5                       EQU     H'0005'
IOCBP4                       EQU     H'0004'
IOCBP3                       EQU     H'0003'
IOCBP2                       EQU     H'0002'
IOCBP1                       EQU     H'0001'
IOCBP0                       EQU     H'0000'

;----- IOCBN Bits -------------------------------------------------------

IOCBN7                       EQU     H'0007'
IOCBN6                       EQU     H'0006'
IOCBN5                       EQU     H'0005'
IOCBN4                       EQU     H'0004'
IOCBN3                       EQU     H'0003'
IOCBN2                       EQU     H'0002'
IOCBN1                       EQU     H'0001'
IOCBN0                       EQU     H'0000'

;----- IOCBF Bits -------------------------------------------------------

IOCBF7                       EQU     H'0007'
IOCBF6                       EQU     H'0006'
IOCBF5                       EQU     H'0005'
IOCBF4                       EQU     H'0004'
IOCBF3                       EQU     H'0003'
IOCBF2                       EQU     H'0002'
IOCBF1                       EQU     H'0001'
IOCBF0                       EQU     H'0000'

;------ T4CON Bits ----------------------------------------------------------

T4OUTPS3                     EQU     H'0006'
T4OUTPS2                     EQU     H'0005'
T4OUTPS1                     EQU     H'0004'
T4OUTPS0                     EQU     H'0003'
TMR4ON                       EQU     H'0002'
T4CKPS1                      EQU     H'0001'
T4CKPS0                      EQU     H'0000'

;------ T6CON Bits ----------------------------------------------------------

T6OUTPS3                     EQU     H'0006'
T6OUTPS2                     EQU     H'0005'
T6OUTPS1                     EQU     H'0004'
T6OUTPS0                     EQU     H'0003'
TMR6ON                       EQU     H'0002'
T6CKPS1                      EQU     H'0001'
T6CKPS0                      EQU     H'0000'

;----- LCDCON Bits --------------------------------------------------------

LCDEN                        EQU     H'0007'
SLPEN                        EQU     H'0006'
WERR                         EQU     H'0005'
CS1                          EQU     H'0003'
CS0                          EQU     H'0002'
LMUX1                        EQU     H'0001'
LMUX0                        EQU     H'0000'

;----- LCDPS Bits ---------------------------------------------------------

WFT                          EQU     H'0007'
BIASMD                       EQU     H'0006'
LCDA                         EQU     H'0005'
WA                           EQU     H'0004'
LP3                          EQU     H'0003'
LP2                          EQU     H'0002'
LP1                          EQU     H'0001'
LP0                          EQU     H'0000'

;----- LCDSE0 Bits --------------------------------------------------------

SE7                          EQU     H'0007'
SE6                          EQU     H'0006'
SE5                          EQU     H'0005'
SE4                          EQU     H'0004'
SE3                          EQU     H'0003'
SE2                          EQU     H'0002'
SE1                          EQU     H'0001'
SE0                          EQU     H'0000'

SEGEN7                       EQU     H'0007'
SEGEN6                       EQU     H'0006'
SEGEN5                       EQU     H'0005'
SEGEN4                       EQU     H'0004'
SEGEN3                       EQU     H'0003'
SEGEN2                       EQU     H'0002'
SEGEN1                       EQU     H'0001'
SEGEN0                       EQU     H'0000'

;----- LCDSE1 Bits --------------------------------------------------------

SE15                         EQU     H'0007'
SE14                         EQU     H'0006'
SE13                         EQU     H'0005'
SE12                         EQU     H'0004'
SE11                         EQU     H'0003'
SE10                         EQU     H'0002'
SE9                          EQU     H'0001'
SE8                          EQU     H'0000'

SEGEN15                      EQU     H'0007'
SEGEN14                      EQU     H'0006'
SEGEN13                      EQU     H'0005'
SEGEN12                      EQU     H'0004'
SEGEN11                      EQU     H'0003'
SEGEN10                      EQU     H'0002'
SEGEN9                       EQU     H'0001'
SEGEN8                       EQU     H'0000'

;----- LCDDATA0 Bits -------------------------------------------------------

SEG7COM0                     EQU     H'0007'
SEG6COM0                     EQU     H'0006'
SEG5COM0                     EQU     H'0005'
SEG4COM0                     EQU     H'0004'
SEG3COM0                     EQU     H'0003'
SEG2COM0                     EQU     H'0002'
SEG1COM0                     EQU     H'0001'
SEG0COM0                     EQU     H'0000'

S7C0                         EQU     H'0007'
S6C0                         EQU     H'0006'
S5C0                         EQU     H'0005'
S4C0                         EQU     H'0004'
S3C0                         EQU     H'0003'
S2C0                         EQU     H'0002'
S1C0                         EQU     H'0001'
S0C0                         EQU     H'0000'

;----- LCDDATA1 Bits -------------------------------------------------------

SEG15COM0                    EQU     H'0007'
SEG14COM0                    EQU     H'0006'
SEG13COM0                    EQU     H'0005'
SEG12COM0                    EQU     H'0004'
SEG11COM0                    EQU     H'0003'
SEG10COM0                    EQU     H'0002'
SEG9COM0                     EQU     H'0001'
SEG8COM0                     EQU     H'0000'

S15C0                        EQU     H'0007'
S14C0                        EQU     H'0006'
S13C0                        EQU     H'0005'
S12C0                        EQU     H'0004'
S11C0                        EQU     H'0003'
S10C0                        EQU     H'0002'
S9C0                         EQU     H'0001'
S8C0                         EQU     H'0000'

;----- LCDDATA3 Bits -------------------------------------------------------

SEG7COM1                     EQU     H'0007'
SEG6COM1                     EQU     H'0006'
SEG5COM1                     EQU     H'0005'
SEG4COM1                     EQU     H'0004'
SEG3COM1                     EQU     H'0003'
SEG2COM1                     EQU     H'0002'
SEG1COM1                     EQU     H'0001'
SEG0COM1                     EQU     H'0000'

S7C1                         EQU     H'0007'
S6C1                         EQU     H'0006'
S5C1                         EQU     H'0005'
S4C1                         EQU     H'0004'
S3C1                         EQU     H'0003'
S2C1                         EQU     H'0002'
S1C1                         EQU     H'0001'
S0C1                         EQU     H'0000'

;----- LCDDATA4 Bits -------------------------------------------------------

SEG15COM1                    EQU     H'0007'
SEG14COM1                    EQU     H'0006'
SEG13COM1                    EQU     H'0005'
SEG12COM1                    EQU     H'0004'
SEG11COM1                    EQU     H'0003'
SEG10COM1                    EQU     H'0002'
SEG9COM1                     EQU     H'0001'
SEG8COM1                     EQU     H'0000'

S15C1                        EQU     H'0007'
S14C1                        EQU     H'0006'
S13C1                        EQU     H'0005'
S12C1                        EQU     H'0004'
S11C1                        EQU     H'0003'
S10C1                        EQU     H'0002'
S9C1                         EQU     H'0001'
S8C1                         EQU     H'0000'

;----- LCDDATA6 Bits -------------------------------------------------------

SEG7COM2                     EQU     H'0007'
SEG6COM2                     EQU     H'0006'
SEG5COM2                     EQU     H'0005'
SEG4COM2                     EQU     H'0004'
SEG3COM2                     EQU     H'0003'
SEG2COM2                     EQU     H'0002'
SEG1COM2                     EQU     H'0001'
SEG0COM2                     EQU     H'0000'

S7C2                         EQU     H'0007'
S6C2                         EQU     H'0006'
S5C2                         EQU     H'0005'
S4C2                         EQU     H'0004'
S3C2                         EQU     H'0003'
S2C2                         EQU     H'0002'
S1C2                         EQU     H'0001'
S0C2                         EQU     H'0000'

;----- LCDDATA7 Bits -------------------------------------------------------

SEG15COM2                    EQU     H'0007'
SEG14COM2                    EQU     H'0006'
SEG13COM2                    EQU     H'0005'
SEG12COM2                    EQU     H'0004'
SEG11COM2                    EQU     H'0003'
SEG10COM2                    EQU     H'0002'
SEG9COM2                     EQU     H'0001'
SEG8COM2                     EQU     H'0000'

S15C2                        EQU     H'0007'
S14C2                        EQU     H'0006'
S13C2                        EQU     H'0005'
S12C2                        EQU     H'0004'
S11C2                        EQU     H'0003'
S10C2                        EQU     H'0002'
S9C2                         EQU     H'0001'
S8C2                         EQU     H'0000'

;----- LCDDATA9 Bits -------------------------------------------------------

SEG7COM3                     EQU     H'0007'
SEG6COM3                     EQU     H'0006'
SEG5COM3                     EQU     H'0005'
SEG4COM3                     EQU     H'0004'
SEG3COM3                     EQU     H'0003'
SEG2COM3                     EQU     H'0002'
SEG1COM3                     EQU     H'0001'
SEG0COM3                     EQU     H'0000'

S7C3                         EQU     H'0007'
S6C3                         EQU     H'0006'
S5C3                         EQU     H'0005'
S4C3                         EQU     H'0004'
S3C3                         EQU     H'0003'
S2C3                         EQU     H'0002'
S1C3                         EQU     H'0001'
S0C3                         EQU     H'0000'

;----- LCDDATA10 Bits -------------------------------------------------------

SEG15COM3                    EQU     H'0007'
SEG14COM3                    EQU     H'0006'
SEG13COM3                    EQU     H'0005'
SEG12COM3                    EQU     H'0004'
SEG11COM3                    EQU     H'0003'
SEG10COM3                    EQU     H'0002'
SEG9COM3                     EQU     H'0001'
SEG8COM3                     EQU     H'0000'

S15C3                        EQU     H'0007'
S14C3                        EQU     H'0006'
S13C3                        EQU     H'0005'
S12C3                        EQU     H'0004'
S11C3                        EQU     H'0003'
S10C3                        EQU     H'0002'
S9C3                         EQU     H'0001'
S8C3                         EQU     H'0000'

;==========================================================================
;
;       RAM Definition
;
;==========================================================================

        __MAXRAM H'7FF'
        __BADRAM H'14', H'1D'-H'1F'
        __BADRAM H'94', H'9F'
        __BADRAM H'11B', H'11D'
        __BADRAM H'18E', H'197'-H'198', H'1A0'-H'1EF'
        __BADRAM H'20C', H'20E'-H'210', H'218'-H'26F'
        __BADRAM H'28C'-H'290', H'297', H'2A0'-H'2EF'
        __BADRAM H'30C'-H'310', H'317', H'31B', H'31F'-H'36F'
        __BADRAM H'38C'-H'393', H'397'-H'3EF'
        __BADRAM H'40C'-H'414', H'418'-H'41B', H'41F'-H'46F'
        __BADRAM H'48C'-H'4EF'
        __BADRAM H'50C'-H'56F'
        __BADRAM H'58C'-H'5EF'
        __BADRAM H'60C'-H'66F'
        __BADRAM H'68C'-H'6EF'
        __BADRAM H'70C'-H'76F'
        __BADRAM H'78C'-H'790', H'794', H'797'-H'79F', H'7A2', H'7A5'
        __BADRAM H'7A8',H'7AB'-H'7EF'
       
;==========================================================================
;
;       Configuration Bits
;
;==========================================================================

_CONFIG1                     EQU     H'2007'

;Configuration Byte 1 Options
_DEBUG_ON                    EQU     H'1FFF'
_DEBUG_OFF                   EQU     H'3FFF'
_FCMEN_ON                    EQU     H'3FFF'
_FCMEN_OFF                   EQU     H'2FFF'
_IESO_ON                     EQU     H'3FFF'
_IESO_OFF                    EQU     H'37FF'
_CLKOUT_ON                   EQU     H'3BFF'
_CLKOUT_OFF                  EQU     H'3FFF'
_BOD_ON                      EQU     H'3FFF'
_BOD_NSLEEP                  EQU     H'3EFF'
_BOD_SBODEN                  EQU     H'3DFF'
_BOD_OFF                     EQU     H'3CFF'
_CPD_ON                      EQU     H'3F7F'
_CPD_OFF                     EQU     H'3FFF'
_CP_ON                       EQU     H'3FBF'
_CP_OFF                      EQU     H'3FFF'
_MCLRE_ON                    EQU     H'3FFF'
_MCLRE_OFF                   EQU     H'3FDF'
_PWRTE_ON                    EQU     H'3FEF'
_PWRTE_OFF                   EQU     H'3FFF'
_WDT_ON                      EQU     H'3FFF'
_WDT_OFF                     EQU     H'3FF7'
_LP_OSC                      EQU     H'3FF8'
_XT_OSC                      EQU     H'3FF9'
_HS_OSC                      EQU     H'3FFA'
_EXTRC_OSC                   EQU     H'3FFB'
_INTOSC                      EQU     H'3FFC'
_ECL                         EQU     H'3FFD'
_ECM                         EQU     H'3FFE'
_ECH                         EQU     H'3FFF'

_CONFIG2                     EQU     H'2008'
 
;Configuration Byte 2 Options
_LVP_ON                      EQU     H'3FFF'
_LVP_OFF                     EQU     H'1FFF'
_BORV_1_9                    EQU     H'3FFF'
_BORV_2_5                    EQU     H'3BFF'
_STVREN_ON                   EQU     H'3FFF'
_STVREN_OFF                  EQU     H'3EFF'
_WDTCS_ON                    EQU     H'3FFF'
_WDTCS_OFF                   EQU     H'3F7F'
_VCAP_RA0_ON                 EQU     H'3FCF'
_VCAP_RA5_ON                 EQU     H'3FDF'
_VCAP_RA6_ON                 EQU     H'3FEF'
_VCAP_OFF                    EQU     H'3FFF'
_WRT_PROTECT_ALL             EQU     H'3FFC'
_WRT_PROTECT_000_7FF         EQU     H'3FFD'
_WRT_PROTECT_000_1FF         EQU     H'3FFE'
_WRT_PROTECT_OFF             EQU     H'3FFF' 

        LIST
